/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Movable;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.shapes.ShapeFactory;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class CircuitTransferable
implements Transferable {
    private String data;

    CircuitTransferable(ArrayList<Movable> data) {
        XStream xStream = Circuit.getxStream();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringWriter out = new StringWriter();){
                out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                xStream.marshal(data, new PrettyPrintWriter(out));
                this.data = out.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<Movable> createList(Object data, ShapeFactory shapeFactory) throws IOException {
        if (!(data instanceof String)) {
            return null;
        }
        XStream xStream = Circuit.getxStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (StringReader in = new StringReader(data.toString());){
            ArrayList elements = (ArrayList)xStream.fromXML(in);
            if (elements == null) {
                return null;
            }
            Iterator iterator = elements.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return elements;
                }
                Movable m = (Movable)iterator.next();
                if (!(m instanceof VisualElement)) continue;
                ((VisualElement)m).setShapeFactory(shapeFactory);
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }
}

