/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.memory.RAMInterface;
import de.neemann.digital.gui.components.DataEditor;
import de.neemann.digital.gui.components.OrderMerger;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ProbeDialog
extends JDialog
implements ModelStateObserverTyped {
    private final ModelEventType type;
    private final SignalTableModel tableModel;
    private boolean tableUpdateEnable = true;
    private final AtomicBoolean paintPending = new AtomicBoolean();

    public ProbeDialog(Frame owner, final Model model, ModelEventType type, List<String> ordering) {
        super(owner, Lang.get("win_measures", new Object[0]), false);
        this.setDefaultCloseOperation(2);
        this.type = type;
        ArrayList<Signal> signals = model.getSignalsCopy();
        new OrderMerger<String, Signal>(ordering){

            @Override
            public boolean equals(Signal a, String b) {
                return a.getName().equals(b);
            }
        }.order(signals);
        this.tableModel = new SignalTableModel(signals, model);
        JTable list = new JTable(this.tableModel);
        list.setRowHeight(list.getFont().getSize() * 6 / 5);
        this.getContentPane().add((Component)new JScrollPane(list), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                model.addObserver(ProbeDialog.this);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                model.removeObserver(ProbeDialog.this);
            }
        });
        List<Node> memoryList = model.findNode(n -> n instanceof RAMInterface);
        if (memoryList.size() > 0) {
            JMenuBar bar = new JMenuBar();
            JMenu memory = new JMenu(Lang.get("menu_probe_memory", new Object[0]));
            memory.setToolTipText(Lang.get("menu_probe_memory_tt", new Object[0]));
            for (final Node n2 : memoryList) {
                if (!(n2 instanceof RAMInterface)) continue;
                final RAMInterface ram = (RAMInterface)((Object)n2);
                String name = ram.getLabel();
                if (name == null || name.length() == 0) {
                    name = ram.getClass().getSimpleName();
                }
                memory.add(new JMenuItem(new ToolTipAction(name){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        new DataEditor(ProbeDialog.this, ram.getMemory(), ram.getDataBits(), ram.getAddrBits(), true, model, ram.getValueFormatter()).setNode(n2).showDialog(ram.getLabel(), model);
                    }
                }));
            }
            bar.add(memory);
            this.setJMenuBar(bar);
        }
        this.setPreferredSize(new Dimension(150, this.getPreferredSize().height));
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    @Override
    public void handleEvent(ModelEvent event) {
        if ((event.getType() == this.type || event == ModelEvent.CHECKBURN) && this.tableUpdateEnable && this.paintPending.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(() -> {
                this.tableModel.fireChanged();
                this.paintPending.set(false);
            });
        }
        switch (event.getType()) {
            case RUN_TO_BREAK: {
                this.tableUpdateEnable = false;
                break;
            }
            case CLOSED: 
            case BREAK: {
                this.tableUpdateEnable = true;
                SwingUtilities.invokeLater(this.tableModel::fireChanged);
            }
        }
    }

    @Override
    public ModelEventType[] getEvents() {
        return new ModelEventType[]{this.type, ModelEventType.CHECKBURN, ModelEventType.RUN_TO_BREAK, ModelEventType.BREAK, ModelEventType.CLOSED};
    }

    private static class SignalTableModel
    implements TableModel {
        private final ArrayList<Signal> signals;
        private final SyncAccess modelSync;
        private final ArrayList<TableModelListener> listeners = new ArrayList();

        SignalTableModel(ArrayList<Signal> signals, SyncAccess modelSync) {
            this.signals = signals;
            this.modelSync = modelSync;
        }

        @Override
        public int getRowCount() {
            return this.signals.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Lang.get("key_Label", new Object[0]);
            }
            return Lang.get("key_Value", new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 && this.signals.get(rowIndex).getSetter() != null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.signals.get(rowIndex).getName();
            }
            return this.signals.get(rowIndex).getValueString();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Signal.Setter s;
            if (columnIndex == 1 && (s = this.signals.get(rowIndex).getSetter()) != null) {
                try {
                    String str = aValue.toString();
                    if (str.equals("?") || str.equals("z") || str.equals("Z")) {
                        this.modelSync.modify(() -> s.set(0L, -1L));
                    } else {
                        long value = Bits.decode(str);
                        this.modelSync.modify(() -> s.set(value, 0L));
                    }
                }
                catch (Bits.NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public void fireChanged() {
            TableModelEvent e = new TableModelEvent(this, 0, this.signals.size() - 1);
            for (TableModelListener l : this.listeners) {
                l.tableChanged(e);
            }
        }
    }
}

