/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.graphics;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.gui.components.graphics.LedMatrixDialog;
import java.awt.Color;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public class LedMatrix
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(LedMatrix.class, PinInfo.input("r-data"), PinInfo.input("c-addr")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.ROW_DATA_BITS).addAttribute(Keys.COL_ADDR_BITS).addAttribute(Keys.COLOR).addAttribute(Keys.LED_PERSISTENCE);
    private final int rowDataBits;
    private final int colAddrBits;
    private final int dx;
    private final int dy;
    private final long[] data;
    private final Color color;
    private final boolean ledPersist;
    private final String label;
    private ObservableValue rowDataVal;
    private ObservableValue colAddrVal;
    private LedMatrixDialog ledMatrixDialog;
    private final AtomicBoolean paintPending = new AtomicBoolean();

    public LedMatrix(ElementAttributes attr) {
        this.rowDataBits = attr.get(Keys.ROW_DATA_BITS);
        this.colAddrBits = attr.get(Keys.COL_ADDR_BITS);
        this.label = attr.getLabel();
        this.color = attr.get(Keys.COLOR);
        this.ledPersist = attr.get(Keys.LED_PERSISTENCE);
        this.dx = 1 << this.colAddrBits;
        this.dy = this.rowDataBits;
        this.data = new long[this.dx];
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.rowDataVal = ((ObservableValue)inputs.get(0)).checkBits(this.rowDataBits, this, 0).addObserverToValue(this);
        this.colAddrVal = ((ObservableValue)inputs.get(1)).checkBits(this.colAddrBits, this, 1).addObserverToValue(this);
    }

    @Override
    public ObservableValues getOutputs() throws PinException {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void readInputs() throws NodeException {
        long rowData = this.rowDataVal.getValue();
        int colAddr = (int)this.colAddrVal.getValue();
        if (!(colAddr >= this.dx || this.ledPersist && this.data[colAddr] == rowData)) {
            this.data[colAddr] = rowData;
            this.dataChanged(colAddr, rowData);
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
    }

    private void dataChanged(int colAddr, long rowData) {
        if (this.paintPending.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(() -> {
                if (this.ledMatrixDialog == null || !this.ledMatrixDialog.isVisible()) {
                    this.ledMatrixDialog = new LedMatrixDialog(this.getModel().getWindowPosManager().getMainFrame(), this.dy, this.data, this.color, this.ledPersist);
                    this.getModel().getWindowPosManager().register("ledMatrix_" + this.label, this.ledMatrixDialog);
                }
                this.paintPending.set(false);
                this.ledMatrixDialog.updateGraphic(colAddr, rowData);
            });
        }
    }
}

