/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.graphics;

import de.neemann.digital.gui.components.graphics.MoveFocusTo;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JDialog;

public class VGADialog
extends JDialog {
    private final MyComponent graphicComponent;

    public VGADialog(Window parent, String title, BufferedImage image) {
        super(parent, title, Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.graphicComponent = new MyComponent(image);
        this.getContentPane().add(this.graphicComponent);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        MoveFocusTo.addListener(this, parent);
    }

    public void updateGraphic() {
        this.graphicComponent.repaint();
    }

    private static final class MyComponent
    extends JComponent {
        private final BufferedImage image;

        private MyComponent(BufferedImage image) {
            this.image = image;
            this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.getWidth() == this.image.getWidth() && this.getHeight() == this.image.getHeight()) {
                g.drawImage(this.image, 0, 0, null);
            } else {
                double sx = (double)this.getWidth() / (double)this.image.getWidth();
                double sy = (double)this.getHeight() / (double)this.image.getHeight();
                double s = Math.min(sx, sy);
                int w = (int)Math.floor((double)this.image.getWidth() * s);
                int h = (int)Math.floor((double)this.image.getHeight() * s);
                int x = (this.getWidth() - w) / 2;
                int y = (this.getHeight() - h) / 2;
                g.drawImage(this.image, x, y, w, h, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
            }
        }
    }
}

