/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.karnaugh;

import de.neemann.digital.gui.components.karnaugh.VarRectList;

public class MapLayout {
    private int mode;
    private int[] swap;

    MapLayout(int size) {
        this.checkSize(size);
    }

    int indexOf(int var) {
        int i = 0;
        while (i < this.swap.length) {
            if (this.swap[i] == var) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void swapVars(int startVar, int endVar) {
        int t = this.swap[startVar];
        this.swap[startVar] = this.swap[endVar];
        this.swap[endVar] = t;
    }

    private void toggleInvert(int n) {
        this.mode ^= 1 << n;
    }

    void checkSize(int size) {
        if (this.swap != null && this.swap.length == size) {
            return;
        }
        this.swap = new int[size];
        int i = 0;
        while (i < this.swap.length) {
            this.swap[i] = i;
            ++i;
        }
        this.mode = 0;
    }

    boolean swapByDragAndDrop(VarRectList.VarRect startVar, VarRectList.VarRect endVar) {
        int end;
        if (startVar == null || endVar == null || startVar.equals(endVar)) {
            return false;
        }
        int start = this.indexOf(startVar.getVar());
        if (start != (end = this.indexOf(endVar.getVar()))) {
            this.swapVars(start, end);
        }
        if (startVar.getInvert() != endVar.getInvert()) {
            this.toggleInvert(end);
        }
        return true;
    }

    boolean getInvert(int n) {
        return (this.mode & 1 << n) > 0;
    }

    int get(int i) {
        return this.swap[i];
    }
}

