/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.draw.graphics.text.formatter.GraphicsFormatter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ExpressionComponent
extends JComponent {
    private static final int XPAD = 5;
    private ArrayList<Expression> expressions;
    private boolean wrongSize = true;

    public void setExpression(Expression expression) {
        ArrayList<Expression> l = new ArrayList<Expression>();
        if (expression != null) {
            l.add(expression);
        }
        this.setExpressions(l);
    }

    public void setExpressions(ArrayList<Expression> expressions) {
        this.expressions = expressions;
        this.updateComponentSize(this.getGraphics());
    }

    protected void updateComponentSize(Graphics gr) {
        if (gr != null) {
            Dimension preferredSize = this.calcSize(gr);
            this.setPreferredSize(preferredSize);
            this.revalidate();
            this.repaint();
            this.wrongSize = false;
        } else {
            this.wrongSize = true;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.getForeground());
        if (this.expressions == null) {
            return;
        }
        Graphics2D gr = this.getGraphics2D(graphics);
        int lineSpacing = this.getFont().getSize() / 2;
        int y = 0;
        for (Expression e : this.expressions) {
            try {
                GraphicsFormatter.Fragment fr = GraphicsFormatter.createFragment(gr, e);
                fr.draw(gr, 5, y += fr.getHeight());
                y += lineSpacing;
            }
            catch (GraphicsFormatter.FormatterException formatterException) {
                // empty catch block
            }
        }
        if (this.wrongSize) {
            SwingUtilities.invokeLater(() -> this.updateComponentSize(graphics));
        }
    }

    private Graphics2D getGraphics2D(Graphics graphics) {
        Graphics2D gr = (Graphics2D)graphics;
        gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return gr;
    }

    private Dimension calcSize(Graphics graphics) {
        Graphics2D gr = this.getGraphics2D(graphics);
        int lineSpacing = gr.getFont().getSize() / 2;
        int dx = 0;
        int y = 0;
        for (Expression e : this.expressions) {
            try {
                GraphicsFormatter.Fragment fr = GraphicsFormatter.createFragment(gr, e);
                y += fr.getHeight() + lineSpacing;
                if (dx >= fr.getWidth()) continue;
                dx = fr.getWidth();
            }
            catch (GraphicsFormatter.FormatterException formatterException) {
                // empty catch block
            }
        }
        return new Dimension(dx + 10, y);
    }
}

