/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ContextFiller;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.gui.components.ElementOrderer;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;

public class ReorderInputs {
    private final TruthTable table;
    private final ArrayList<String> names;

    public ReorderInputs(TruthTable table, ArrayList<String> names) {
        this.table = table;
        this.names = names;
    }

    public ReorderInputs(TruthTable table) {
        this.table = table;
        this.names = new ArrayList();
        for (Variable v : table.getVars()) {
            this.names.add(v.getIdentifier());
        }
    }

    public ElementOrderer.OrderInterface<String> getItems() {
        return new ElementOrderer.ListOrder<String>(this.names);
    }

    /*
     * WARNING - void declaration
     */
    public void reorder() throws ExpressionException {
        ArrayList<Variable> newVars = new ArrayList<Variable>();
        ArrayList<Variable> deletedVars = new ArrayList<Variable>(this.table.getVars());
        for (String name : this.names) {
            Variable found = null;
            for (Variable variable : deletedVars) {
                if (!variable.getIdentifier().equals(name)) continue;
                found = variable;
                break;
            }
            if (found == null) continue;
            newVars.add(found);
            deletedVars.remove(found);
        }
        if (newVars.size() < 2) {
            throw new ExpressionException(Lang.get("err_tableBecomesToSmall", new Object[0]));
        }
        TruthTable oldTable = this.table.createDeepCopy();
        this.table.clear(newVars);
        int j = 0;
        while (j < oldTable.getResultCount()) {
            this.table.addResult(oldTable.getResultName(j));
            ++j;
        }
        ContextFiller fc = new ContextFiller(this.table.getVars());
        for (Variable v : deletedVars) {
            fc.set(v, false);
        }
        int row = 0;
        while (row < this.table.getRows()) {
            void var6_12;
            fc.setContextTo(row);
            boolean bl = false;
            while (var6_12 < this.table.getResultCount()) {
                this.table.setByContext((int)var6_12, fc, oldTable.getByContext((int)var6_12, fc));
                ++var6_12;
            }
            ++row;
        }
    }
}

