/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.TruthTableTableModel;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.gui.components.table.ReorderInputs;
import de.neemann.digital.gui.components.table.ReorderOutputs;
import de.neemann.digital.gui.components.table.TableDialog;
import de.neemann.digital.undo.ModifyException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableModel;

class TableReorderManager {
    private final TableDialog tableDialog;
    private final JTable table;

    TableReorderManager(TableDialog tableDialog, final JTable table) {
        this.tableDialog = tableDialog;
        this.table = table;
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TableModel m;
                if (mouseEvent.getButton() == 1 && (m = table.getModel()) instanceof TruthTableTableModel) {
                    TableReorderManager.this.checkReorder((TruthTableTableModel)m);
                }
            }
        });
    }

    private void checkReorder(TruthTableTableModel model) {
        ArrayList<Variable> varList = model.getTable().getVars();
        ArrayList<String> vars = new ArrayList<String>();
        ArrayList<String> results = new ArrayList<String>();
        boolean wasChange = false;
        int i = 0;
        while (i < model.getColumnCount()) {
            BoolTable r;
            String name = this.table.getTableHeader().getColumnModel().getColumn(i).getHeaderValue().toString();
            if (!name.equals(this.table.getModel().getColumnName(i))) {
                wasChange = true;
            }
            if ((r = model.getTable().getResult(name)) != null && varList.contains(new Variable(name))) {
                return;
            }
            if (r != null) {
                results.add(name);
            } else {
                vars.add(name);
            }
            ++i;
        }
        if (wasChange) {
            try {
                if (this.isVarChange(varList, vars)) {
                    this.tableDialog.getUndoManager().apply(tt -> {
                        try {
                            new ReorderInputs((TruthTable)tt, vars).reorder();
                        }
                        catch (ExpressionException e) {
                            e.printStackTrace();
                        }
                    });
                    this.tableDialog.tableChanged();
                } else if (this.isResultChange(model.getTable(), results)) {
                    this.tableDialog.getUndoManager().apply(tt -> {
                        try {
                            new ReorderOutputs((TruthTable)tt, results).reorder();
                        }
                        catch (ExpressionException e) {
                            e.printStackTrace();
                        }
                    });
                    this.tableDialog.tableChanged();
                } else {
                    this.tableDialog.tableChanged();
                }
            }
            catch (ModifyException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isResultChange(TruthTable table, ArrayList<String> results) {
        if (table.getResultCount() != results.size()) {
            return false;
        }
        int i = 0;
        while (i < results.size()) {
            if (!table.getResultName(i).equals(results.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isVarChange(ArrayList<Variable> varList, ArrayList<String> vars) {
        if (varList.size() != vars.size()) {
            return false;
        }
        int i = 0;
        while (i < varList.size()) {
            if (!varList.get(i).getIdentifier().equals(vars.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

