/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.components.table.hardware;

import de.neemann.digital.analyse.ModelAnalyserInfo;
import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.modify.ExpressionModifier;
import de.neemann.digital.builder.Gal16v8.CuplExporter;
import de.neemann.digital.gui.components.table.BuilderExpressionCreator;
import de.neemann.digital.gui.components.table.ExpressionListenerStore;
import de.neemann.digital.gui.components.table.hardware.HardwareDescriptionGenerator;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.MyFileChooser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JDialog;

public class GenerateCUPL
implements HardwareDescriptionGenerator {
    private CuplExporterFactory cuplExporterFactory;
    private String menuPath;

    public GenerateCUPL(CuplExporterFactory cuplExporterFactory, String menuPath) {
        this.cuplExporterFactory = cuplExporterFactory;
        this.menuPath = menuPath;
    }

    @Override
    public String getMenuPath() {
        return this.menuPath;
    }

    @Override
    public String getDescription() {
        return Lang.get("menu_table_createCUPL_tt", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void generate(JDialog parent, File circuitFile, TruthTable table, ExpressionListenerStore expressions) throws Exception {
        File cuplPath;
        if (circuitFile == null) {
            MyFileChooser fc = new MyFileChooser();
            fc.setFileSelectionMode(1);
            fc.setDialogTitle(Lang.get("msg_selectAnEmptyFolder", new Object[0]));
            if (fc.showSaveDialog(parent) != 0) return;
            circuitFile = cuplPath = fc.getSelectedFile();
        } else if (circuitFile.isDirectory()) {
            cuplPath = circuitFile;
        } else {
            String name = circuitFile.getName();
            if (name.length() > 3 && name.charAt(name.length() - 4) == '.') {
                name = name.substring(0, name.length() - 4);
            }
            cuplPath = new File(circuitFile.getParentFile(), "CUPL_" + name);
        }
        if (!cuplPath.mkdirs() && !cuplPath.exists()) {
            throw new IOException(Lang.get("err_couldNotCreateFolder_N0", cuplPath.getPath()));
        }
        File f = new File(cuplPath, "CUPL.PLD");
        CuplExporter cuplExporter = this.cuplExporterFactory.create();
        cuplExporter.setProjectName(circuitFile.getName());
        ModelAnalyserInfo modelAnalyzerInfo = table.getModelAnalyzerInfo();
        if (modelAnalyzerInfo != null) {
            cuplExporter.getPinMapping().addAll(modelAnalyzerInfo.getPins());
        }
        new BuilderExpressionCreator(cuplExporter.getBuilder(), ExpressionModifier.IDENTITY).create(expressions);
        Throwable throwable = null;
        Object var10_11 = null;
        try (FileOutputStream out = new FileOutputStream(f);){
            cuplExporter.writeTo(out);
            return;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            } else {
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static interface CuplExporterFactory {
        public CuplExporter create();
    }
}

