/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.gui.state;

import de.neemann.digital.gui.state.StateInterface;
import de.neemann.digital.gui.state.StateManager;
import de.neemann.gui.ToolTipAction;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class State
implements StateInterface {
    private static final Border ENABLED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4));
    private static final Border DISABLED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(4, 4, 4, 4));
    private JComponent indicator;
    private StateManager stateManager;
    private ToolTipAction action;

    public <C extends JComponent> C setIndicator(C indicator) {
        this.indicator = indicator;
        indicator.setBorder(DISABLED_BORDER);
        return indicator;
    }

    void setStateManager(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    public void enter() {
        this.stateManager.leaveActualStateAndSet(this);
        if (this.indicator != null) {
            this.indicator.setBorder(ENABLED_BORDER);
        }
    }

    @Override
    public void leave() {
        if (this.indicator != null) {
            this.indicator.setBorder(DISABLED_BORDER);
        }
    }

    public ToolTipAction getAction() {
        return this.action;
    }

    public ToolTipAction createToolTipAction(String name, Icon icon) {
        if (this.action == null) {
            this.action = new ToolTipAction(name, icon){

                @Override
                public void actionPerformed(ActionEvent e) {
                    State.this.enter();
                }
            };
        }
        return this.action;
    }

    public boolean isActive() {
        return this.stateManager.isActive(this);
    }
}

