/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.hdl.model2.HDLModel;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.expression.ExprVar;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.expression.ExpressionOptimizer;
import de.neemann.digital.hdl.model2.expression.Visitor;
import de.neemann.digital.hdl.printer.CodePrinter;
import java.io.IOException;

public class HDLNodeAssignment
extends HDLNode {
    private Expression expression;

    public HDLNodeAssignment(String elementName, ElementAttributes elementAttributes, HDLModel.BitProvider bitProvider) {
        super(elementName, elementAttributes, bitProvider);
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public void print(CodePrinter out) throws IOException {
        super.print(out);
        this.getOutput().getNet().print(out);
        out.print(" := ");
        this.expression.print(out);
        out.println();
    }

    @Override
    public void replaceNet(HDLNet oldNet, HDLNet newNet) {
        super.replaceNet(oldNet, newNet);
        this.expression.replace(oldNet, new ExprVar(newNet));
    }

    @Override
    public <V extends Visitor> V traverseExpressions(V visitor) {
        this.expression.traverse(visitor);
        return visitor;
    }

    @Override
    public void replaceNetByExpression(HDLNet net, Expression expression) {
        expression.replace(net, expression);
    }

    public HDLNet getTargetNet() {
        return this.getOutput().getNet();
    }

    public void optimize(ExpressionOptimizer eo) {
        this.expression = eo.optimize(this.expression);
    }
}

