/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2;

import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.HDLNode;
import de.neemann.digital.hdl.model2.HDLPort;
import de.neemann.digital.hdl.model2.Printable;
import de.neemann.digital.hdl.model2.expression.ExprVar;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.expression.Visitor;
import de.neemann.digital.hdl.printer.CodePrinter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class HDLNodeSplitterManyToOne
extends HDLNode
implements Iterable<SplitterAssignment> {
    private final ArrayList<SplitterAssignment> outputs = new ArrayList();

    HDLNodeSplitterManyToOne(HDLNode node, Splitter.Ports inputSplit) {
        super(node.getElementName(), node.getElementAttributes(), null);
        int i = 0;
        for (Splitter.Port port : inputSplit) {
            this.outputs.add(new SplitterAssignment(port.getPos() + port.getBits() - 1, port.getPos(), new ExprVar(node.getInputs().get(i).getNet())));
            ++i;
        }
        for (HDLPort hDLPort : node.getInputs()) {
            this.addPort(hDLPort);
        }
        for (HDLPort hDLPort : node.getOutputs()) {
            this.addPort(hDLPort);
        }
    }

    public String getTargetSignal() {
        HDLNet net = this.getOutput().getNet();
        if (net == null) {
            return null;
        }
        return net.getName();
    }

    @Override
    public void print(CodePrinter out) throws IOException {
        super.print(out);
        int i = 0;
        HDLPort o = this.getOutput();
        for (SplitterAssignment sp : this) {
            out.print(o.getNet().getName());
            this.outputs.get(i++).print(out);
            out.println();
        }
    }

    @Override
    public void replaceNetByExpression(HDLNet net, Expression expression) {
        for (SplitterAssignment p : this) {
            p.replace(net, expression);
        }
    }

    @Override
    public <V extends Visitor> V traverseExpressions(V visitor) {
        for (SplitterAssignment p : this) {
            p.traverseExpressions(visitor);
        }
        return visitor;
    }

    @Override
    public Iterator<SplitterAssignment> iterator() {
        return this.outputs.iterator();
    }

    public static final class SplitterAssignment
    implements Printable {
        private final int msb;
        private final int lsb;
        private Expression expression;

        private SplitterAssignment(int msb, int lsb, Expression expression) {
            this.msb = msb;
            this.lsb = lsb;
            this.expression = expression;
        }

        @Override
        public void print(CodePrinter out) throws IOException {
            out.print("(").print(this.msb).print("-").print(this.lsb).print(")").print(" := ");
            this.expression.print(out);
        }

        public int getMsb() {
            return this.msb;
        }

        public int getLsb() {
            return this.lsb;
        }

        public Expression getExpression() {
            return this.expression;
        }

        private void replace(HDLNet net, Expression expr) {
            if (Expression.isVar(this.expression, net)) {
                this.expression = expr;
            } else {
                this.expression.replace(net, expr);
            }
        }

        private void traverseExpressions(Visitor visitor) {
            this.expression.traverse(visitor);
        }
    }
}

