/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.clock;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.hdl.model2.HDLCircuit;
import de.neemann.digital.hdl.model2.HDLException;
import de.neemann.digital.hdl.model2.HDLNodeBuildIn;
import de.neemann.digital.hdl.model2.clock.ClockInfo;
import de.neemann.digital.hdl.model2.clock.HDLClockIntegrator;
import java.util.ArrayList;

public class ClockIntegratorGeneric
implements HDLClockIntegrator {
    private static final Key<Integer> COUNTER_KEY = new Key<Integer>("maxCounter", 0);
    private double periodns;
    private String clockGenerator;

    public ClockIntegratorGeneric(double periodns) {
        this.periodns = periodns;
    }

    public ClockIntegratorGeneric setClockGenerator(String clockGenerator) {
        this.clockGenerator = clockGenerator;
        return this;
    }

    @Override
    public void integrateClocks(HDLCircuit circuit, ArrayList<ClockInfo> clocks) throws HDLException {
        for (ClockInfo ci : clocks) {
            int freq = ci.getFrequency();
            int counter = (int)(1.0E9 / (this.periodns * 2.0 * (double)freq));
            if (counter < 2) continue;
            ElementAttributes attributes = new ElementAttributes().set(COUNTER_KEY, counter);
            if (this.clockGenerator != null) {
                attributes.set(new Key<String>("clockGenerator", ""), this.clockGenerator);
            }
            HDLNodeBuildIn node = new HDLNodeBuildIn("simpleClockDivider", attributes, name -> 1);
            circuit.integrateClockNode(ci.getClockPort(), node);
        }
    }
}

