/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.hdl.model2.expression;

import de.neemann.digital.hdl.model2.HDLNet;
import de.neemann.digital.hdl.model2.expression.Expression;
import de.neemann.digital.hdl.model2.expression.ExpressionOptimizer;
import de.neemann.digital.hdl.model2.expression.Visitor;
import de.neemann.digital.hdl.printer.CodePrinter;
import java.io.IOException;

public class ExprNot
implements Expression {
    private Expression expr;

    public ExprNot(Expression expr) {
        this.expr = expr;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public void print(CodePrinter out) throws IOException {
        out.print("NOT ");
        this.expr.print(out);
    }

    @Override
    public void replace(HDLNet net, Expression expression) {
        if (Expression.isVar(this.expr, net)) {
            this.expr = expression;
        } else {
            this.expr.replace(net, expression);
        }
    }

    @Override
    public void traverse(Visitor visitor) {
        visitor.visit(this);
        this.expr.traverse(visitor);
    }

    @Override
    public void optimize(ExpressionOptimizer eo) {
        this.expr = eo.optimize(this.expr);
        this.expr.optimize(eo);
    }

    public static class OptimizeNotNot
    implements ExpressionOptimizer {
        @Override
        public Expression optimize(Expression expression) {
            ExprNot not;
            if (expression instanceof ExprNot && (not = (ExprNot)expression).expr instanceof ExprNot) {
                return this.optimize(((ExprNot)not.expr).expr);
            }
            return expression;
        }
    }
}

