/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.lang;

import de.neemann.gui.language.Bundle;
import de.neemann.gui.language.Language;
import de.neemann.gui.language.Resources;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.prefs.Preferences;

public final class Lang {
    private static final Preferences PREFS = Preferences.userRoot().node("dig");
    private static final String LANGUAGE = "lang";
    private final Bundle bundle = new Bundle("lang/lang");
    private final Resources defaultBundle = this.bundle.getResources("en");
    private Resources localeBundle;
    private Language currentLanguage;

    public static String get(String key, Object ... params) {
        return InstanceHolder.INSTANCE.getKey(key, params);
    }

    public static void setLanguage(Language language) {
        PREFS.put(LANGUAGE, language.getName());
    }

    public static String getNull(String key, Object ... params) {
        return InstanceHolder.INSTANCE.getKeyNull(key, params);
    }

    public static Bundle getBundle() {
        return InstanceHolder.INSTANCE.bundle;
    }

    public static Language currentLanguage() {
        return InstanceHolder.INSTANCE.currentLanguage;
    }

    public static void setActualRuntimeLanguage(Language language) {
        InstanceHolder.INSTANCE.setRuntimeLanguage(language);
    }

    private Lang() {
        String lang = PREFS.get(LANGUAGE, Locale.getDefault().getLanguage());
        try {
            this.localeBundle = this.bundle.getResources(lang);
        }
        catch (Exception e) {
            this.localeBundle = null;
            System.err.println("error reading translation for " + lang);
            e.printStackTrace();
        }
        this.currentLanguage = this.localeBundle != null ? new Language(lang) : new Language("en");
    }

    public static String evalMultilingualContent(String text) {
        return Lang.evalMultilingualContent(text, Lang.currentLanguage());
    }

    static String evalMultilingualContent(String text, Language currentLanguage) {
        int pos = text.indexOf("{{");
        if (pos < 0) {
            return text;
        }
        String def = text.substring(0, pos).trim();
        do {
            int p2 = pos + 1;
            int count = 1;
            while (count > 0) {
                char c = text.charAt(p2);
                if (c == '{') {
                    ++count;
                } else if (c == '}') {
                    --count;
                }
                if (++p2 != text.length() || count <= 0) continue;
                p2 = 1;
                break;
            }
            if ((p2 -= 2) > pos + 3) {
                String l = text.substring(pos + 2, pos + 4);
                if (l.equalsIgnoreCase(currentLanguage.getName())) {
                    return text.substring(pos + 4, p2).trim();
                }
                if (l.equalsIgnoreCase("en") && def.isEmpty()) {
                    def = text.substring(pos + 4, p2).trim();
                }
            } else {
                return def;
            }
            pos = text.indexOf("{{", p2);
        } while (pos > 0);
        return def;
    }

    private void setRuntimeLanguage(Language lang) {
        this.currentLanguage = lang;
        this.localeBundle = this.bundle.getResources(lang.getName());
    }

    private String getKey(String key, Object ... params) {
        String str = this.getKeyNull(key, params);
        if (str != null) {
            return str;
        }
        System.out.println("<string name=\"" + key + "\">" + key.substring(key.indexOf("_") + 1) + "</string>");
        if (System.getProperty("testdata") != null) {
            throw new Error("missing language key '" + key + "'");
        }
        return String.valueOf(key) + " " + Arrays.asList(params).toString();
    }

    private String getKeyNull(String key, Object ... params) {
        String str = null;
        if (this.localeBundle != null) {
            str = this.decodeString(this.localeBundle, key, params);
        }
        if (str == null) {
            str = this.decodeString(this.defaultBundle, key, params);
        }
        return str;
    }

    private String decodeString(Resources resources, String key, Object[] params) {
        String str = resources.get(key);
        if (str != null && params != null && params.length > 0) {
            str = MessageFormat.format(str, params);
        }
        return str;
    }

    /* synthetic */ Lang(Lang lang) {
        this();
    }

    private static class InstanceHolder {
        static final Lang INSTANCE = new Lang(null);

        private InstanceHolder() {
        }
    }
}

