/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestExecutor;
import de.neemann.digital.testing.TestResult;
import de.neemann.digital.testing.TestingDataException;
import de.neemann.digital.testing.parser.ParserException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class FolderTestRunner {
    private final ArrayList<FileToTest> files = new ArrayList();
    private Thread thread;

    public FolderTestRunner(File folder) {
        this.scan(folder.getPath().length() + 1, folder);
    }

    private void scan(int rootLength, File folder) {
        File[] fileList = folder.listFiles();
        if (fileList != null) {
            Arrays.sort(fileList, Comparator.comparing(f -> f.getPath().toLowerCase()));
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File f2 = fileArray[n2];
                if (f2.isDirectory()) {
                    this.scan(rootLength, f2);
                } else if (f2.isFile() && f2.getName().endsWith(".dig")) {
                    this.files.add(new FileToTest(rootLength, f2));
                }
                ++n2;
            }
        }
    }

    public void startTests(FileChangedListener fileChangedListener, ShapeFactory shapeFactory, ElementLibrary library) {
        this.thread = new Thread(new TestRunner(this.files, fileChangedListener, shapeFactory, library));
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void waitUntilFinished() throws InterruptedException {
        this.thread.join();
    }

    public ArrayList<FileToTest> getFiles() {
        return this.files;
    }

    public static interface FileChangedListener {
        public void messageChanged(FileToTest var1, int var2);
    }

    public static final class FileToTest {
        private final File file;
        private final String name;
        private String message = "-";
        private Status status = Status.unknown;
        private int rowCount;

        private FileToTest(int rootLength, File file) {
            this.file = file;
            this.name = file.getPath().substring(rootLength);
        }

        public String getName() {
            return this.name;
        }

        private void setMessage(String message, Status status) {
            this.message = message;
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public Status getStatus() {
            return this.status;
        }

        public File getFile() {
            return this.file;
        }

        private void setTestRows(int rowCount) {
            this.rowCount = rowCount;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public static enum Status {
            unknown,
            passed,
            error,
            failed;

        }
    }

    private static final class TestRunner
    implements Runnable {
        private final ArrayList<FileToTest> files;
        private final FileChangedListener fileChangedListener;
        private final ShapeFactory shapeFactory;
        private final ElementLibrary library;

        private TestRunner(ArrayList<FileToTest> files, FileChangedListener fileChangedListener, ShapeFactory shapeFactory, ElementLibrary library) {
            this.files = files;
            this.fileChangedListener = fileChangedListener;
            this.shapeFactory = shapeFactory;
            this.library = library;
        }

        @Override
        public void run() {
            int i = 0;
            while (i < this.files.size()) {
                FileToTest f = this.files.get(i);
                try {
                    Circuit circuit = Circuit.loadCircuit(f.file, this.shapeFactory);
                    List<Circuit.TestCase> testCases = circuit.getTestCases();
                    if (testCases.isEmpty()) {
                        try {
                            new ModelCreator(circuit, this.library).createModel(false);
                            this.setMessage(f, i, Lang.get("err_noTestData", new Object[0]), FileToTest.Status.unknown);
                        }
                        catch (Exception e) {
                            this.setMessage(f, i, Lang.get("msg_errorCreatingModel", new Object[0]), FileToTest.Status.error);
                        }
                    } else {
                        StringBuilder sb = new StringBuilder();
                        int rowCount = 0;
                        for (Circuit.TestCase tc : testCases) {
                            try {
                                TestResult tr = new TestExecutor(tc, circuit, this.library).execute();
                                if (tr.allPassed()) {
                                    rowCount += tr.getRowsTested();
                                    continue;
                                }
                                if (sb.length() > 0) {
                                    sb.append("; ");
                                }
                                sb.append(Lang.get("msg_test_N_Failed", tc.getLabel()));
                            }
                            catch (NodeException | TestingDataException e) {
                                if (sb.length() > 0) {
                                    sb.append("; ");
                                }
                                sb.append(tc.getLabel()).append(": ").append(e.getMessage());
                            }
                        }
                        if (sb.length() == 0) {
                            f.setTestRows(rowCount);
                            this.setMessage(f, i, Lang.get("msg_testPassed_N", rowCount), FileToTest.Status.passed);
                        } else {
                            this.setMessage(f, i, sb.toString(), FileToTest.Status.failed);
                        }
                    }
                }
                catch (PinException | ElementNotFoundException | ParserException | IOException | RuntimeException e) {
                    this.setMessage(f, i, e.getMessage(), FileToTest.Status.error);
                }
                ++i;
            }
        }

        private void setMessage(FileToTest f, int i, String message, FileToTest.Status status) {
            f.setMessage(message, status);
            this.fileChangedListener.messageChanged(f, i);
        }
    }
}

