/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing;

import de.neemann.digital.data.Value;
import de.neemann.digital.testing.TestExecutor;
import de.neemann.digital.testing.parser.LineListener;
import de.neemann.digital.testing.parser.TestRow;
import java.util.ArrayList;
import java.util.Iterator;

public class LineListenerResolveDontCare
implements LineListener {
    private final LineListener parent;
    private final ArrayList<TestExecutor.TestSignal> inputs;

    public LineListenerResolveDontCare(LineListener parent, ArrayList<TestExecutor.TestSignal> inputs) {
        this.parent = parent;
        this.inputs = inputs;
    }

    @Override
    public void add(TestRow testRow) {
        Value[] row = testRow.getValues();
        ArrayList<Integer> dcIndex = null;
        for (TestExecutor.TestSignal in : this.inputs) {
            if (row[in.getIndex()].getType() != Value.Type.DONTCARE) continue;
            if (dcIndex == null) {
                dcIndex = new ArrayList<Integer>();
            }
            dcIndex.add(in.getIndex());
        }
        if (dcIndex == null) {
            this.parent.add(testRow);
        } else {
            int count = 1 << dcIndex.size();
            int n = 0;
            while (n < count) {
                int mask = 1;
                Iterator iterator = dcIndex.iterator();
                while (iterator.hasNext()) {
                    int in = (Integer)iterator.next();
                    boolean val = (n & mask) != 0;
                    row[in] = new Value(val ? 1 : 0);
                    mask *= 2;
                }
                this.parent.add(new TestRow(row, String.valueOf(testRow.getDescription()) + ";X=" + n));
                ++n;
            }
        }
    }
}

