/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.ProgramMemory;
import de.neemann.digital.core.memory.RAMInterface;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.shapes.ShapeFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class UnitTester {
    private final Model model;
    private boolean initCalled = false;

    public UnitTester(File file) throws IOException, ElementNotFoundException, PinException, NodeException {
        ElementLibrary library = new ElementLibrary();
        library.setRootFilePath(file.getAbsoluteFile().getParentFile());
        this.initLibrary(library);
        ShapeFactory shapeFactory = new ShapeFactory(library);
        Circuit circuit = Circuit.loadCircuit(file, shapeFactory);
        this.model = new ModelCreator(circuit, library).createModel(false);
    }

    protected void initLibrary(ElementLibrary library) {
    }

    public UnitTester writeDataTo(MemoryFilter filter, DataField data) throws TestException {
        this.getMemory(filter).setProgramMemory(data);
        return this;
    }

    public ProgramMemory getMemory(MemoryFilter filter) throws TestException {
        Node node = this.getNode(n -> n instanceof ProgramMemory && filter.accept((ProgramMemory)((Object)n)));
        return (ProgramMemory)((Object)node);
    }

    public RAMInterface getRAM() throws TestException {
        return this.getRAM(pm -> true);
    }

    public RAMInterface getRAM(MemoryFilter filter) throws TestException {
        Node node = this.getNode(n -> n instanceof RAMInterface && filter.accept((RAMInterface)((Object)n)));
        return (RAMInterface)((Object)node);
    }

    public Node getNode(Model.NodeFilter<Node> filter) throws TestException {
        List<Node> list = this.model.findNode(filter);
        if (list.size() == 0) {
            throw new TestException("no node found");
        }
        if (list.size() > 1) {
            throw new TestException("multiple nodes found");
        }
        return list.get(0);
    }

    public UnitTester runToBreak() throws TestException, NodeException {
        if (!this.model.isRunToBreakAllowed()) {
            throw new TestException("model has no break or no clock element");
        }
        this.getModel().runToBreak();
        return this;
    }

    public Model getModel() throws NodeException {
        if (!this.initCalled) {
            this.model.init();
            this.initCalled = true;
        }
        return this.model;
    }

    public static interface MemoryFilter {
        public boolean accept(ProgramMemory var1);
    }

    public static final class TestException
    extends Exception {
        private TestException(String message) {
            super(message);
        }
    }
}

