/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.testing.parser;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Signal;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.parser.ParserException;
import java.util.HashMap;
import java.util.Map;

public class Context {
    private final Context parent;
    private HashMap<String, Long> map;
    private Model model;
    private SeedReset seedReset;

    public Context() {
        this(null);
    }

    public Context(Context parent) {
        this.parent = parent;
    }

    public long getVar(String name) throws ParserException {
        if (this.map == null || !this.map.containsKey(name)) {
            if (this.parent == null) {
                if (this.model != null) {
                    for (Signal s : this.model.getTestOutputs()) {
                        if (!s.getName().equals(name)) continue;
                        return s.getValue().getValue();
                    }
                }
                throw new ParserException(Lang.get("err_variable_N0_notFound", name));
            }
            return this.parent.getVar(name);
        }
        return this.map.get(name);
    }

    public Context setVar(String varName, long value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(varName, value);
        return this;
    }

    public String toString() {
        if (this.map == null && this.parent == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.fillString(sb);
        return sb.toString();
    }

    private void fillString(StringBuilder sb) {
        if (this.parent != null) {
            this.parent.fillString(sb);
        }
        if (this.map != null) {
            for (Map.Entry<String, Long> e : this.map.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(e.getKey()).append("=").append(e.getValue());
            }
        }
    }

    public Context setModel(Model model) {
        this.model = model;
        return this;
    }

    public void resetRandom() {
        this.seedReset.resetSeed();
    }

    public Context setSeedReset(SeedReset seedReset) {
        this.seedReset = seedReset;
        return this;
    }

    public static interface SeedReset {
        public void resetSeed();
    }
}

