/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui;

import de.neemann.digital.lang.Lang;
import de.neemann.gui.IconCreator;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;

public final class InfoDialog
implements Iterable<Manifest> {
    public static final String UNKNOWN = "unknown";
    private static InfoDialog instance;
    private final ArrayList<Manifest> infos = new ArrayList();
    private String revision = "unknown";

    public static InfoDialog getInstance() {
        if (instance == null) {
            try {
                instance = new InfoDialog();
            }
            catch (IOException e) {
                System.out.println("error reading InfoDialog " + e.getMessage());
            }
        }
        return instance;
    }

    private InfoDialog() throws IOException {
        Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resEnum.hasMoreElements()) {
            Manifest m = new Manifest(resEnum.nextElement());
            if (m.get("Build-SCM-Revision") == null) continue;
            this.infos.add(m);
            this.revision = m.get("Build-SCM-Revision");
        }
    }

    private String createMessage(String message) {
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(message.replace("\n\n", "<br/><br/>"));
        sb.append("<br/><br/>");
        this.append(sb, "OS", "os.name");
        this.append(sb, "OS version", "os.version");
        this.append(sb, "JRE", "java.version");
        this.append(sb, "VM", "java.vm.version");
        for (Manifest m : this.infos) {
            m.createInfoString(sb);
        }
        return sb.append("</html>").toString();
    }

    private void append(StringBuilder sb, String name, String key) {
        sb.append(name).append(": ").append(System.getProperties().getProperty(key)).append("<br/>");
    }

    public static void showInfo(Window parent, String message, String revision) {
        final JDialog dialog = new JDialog(parent, Lang.get("menu_about", new Object[0]), Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setDefaultCloseOperation(2);
        JEditorPane ta = new JEditorPane("text/html", message);
        ta.setCaretPosition(0);
        ta.putClientProperty("JEditorPane.honorDisplayProperties", true);
        ta.setEditable(false);
        ta.setBackground(new JLabel().getBackground());
        ta.setSize(new Dimension(400, 800));
        ta.setPreferredSize(new Dimension(400, ta.getPreferredSize().height + 30));
        Font font = ta.getFont().deriveFont(1);
        ta.setFont(font);
        int border = font.getSize();
        ta.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
        dialog.getContentPane().add(ta);
        ta.addHyperlinkListener(hyperlinkEvent -> {
            if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                Desktop desktop;
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        String name = Preferences.userRoot().node("dig").get("newname", "Digital");
                        URL url = hyperlinkEvent.getURL();
                        url = new URL(url.toString().replace("[[version]]", revision).replace("[[name]]", name));
                        desktop.browse(url.toURI());
                    }
                    catch (IOException | URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JPanel buttons = new JPanel(new FlowLayout(2));
        JButton button = new JButton(new AbstractAction(Lang.get("ok", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dialog.dispose();
            }
        });
        buttons.add(button);
        dialog.getContentPane().add((Component)buttons, "South");
        JLabel l = new JLabel(IconCreator.create("icon64.png"));
        l.setVerticalAlignment(1);
        l.setBorder(BorderFactory.createEmptyBorder(border, border, border, 0));
        dialog.getContentPane().add((Component)l, "West");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public JMenuItem createMenuItem(final JFrame frame, final String message) {
        return new JMenuItem(new AbstractAction(Lang.get("menu_about", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoDialog.showInfo(frame, InfoDialog.this.createMessage(message), InfoDialog.this.revision);
            }
        });
    }

    @Override
    public Iterator<Manifest> iterator() {
        return this.infos.iterator();
    }

    public String getRevision() {
        return this.revision;
    }

    public static final class Manifest {
        private static final String REVISION = "Build-SCM-Revision";
        private static final String TIME = "Build-Time";
        private final HashMap<String, String> manifest;
        private final URL url;

        private Manifest(URL url) throws IOException {
            this.url = url;
            this.manifest = new HashMap();
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int p = line.indexOf(58);
                    if (p < 0) continue;
                    String key = line.substring(0, p).trim();
                    String value = line.substring(p + 1).trim();
                    this.manifest.put(key, value);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private String get(String key) {
            return this.manifest.get(key);
        }

        public HashMap<String, String> getEntries() {
            return this.manifest;
        }

        public URL getUrl() {
            return this.url;
        }

        private void createInfoString(StringBuilder sb) {
            String path = this.url.getPath();
            int p = path.lastIndexOf("!/");
            path = path.substring(0, p);
            p = path.lastIndexOf(47);
            sb.append("<p>");
            sb.append(path.substring(p + 1)).append("<br/>");
            sb.append("Build Git-Revision").append(": ");
            sb.append(this.get(REVISION)).append("<br/>");
            sb.append("Build Time").append(": ");
            sb.append(this.get(TIME)).append("<br/></p>");
        }

        public String toString() {
            return "Manifest{manifest=" + this.manifest + ", url=" + this.url + '}';
        }
    }
}

