/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.gui;

public class LineBreaker {
    private static final int DEF_COLS = 70;
    private final String label;
    private final int indent;
    private final int cols;
    private final StringBuilder outText;
    private String lineBreak = "\n";
    private boolean isFirst;
    private int pos;
    private boolean preserveLineBreaks = false;
    private boolean toHTML = false;
    private int lines;

    public LineBreaker() {
        this(70);
    }

    public LineBreaker(int cols) {
        this("", 0, cols);
    }

    public LineBreaker(String label, int indent, int cols) {
        this.label = label;
        this.indent = indent;
        this.cols = cols;
        this.outText = new StringBuilder(label);
        this.isFirst = true;
    }

    public LineBreaker setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
        return this;
    }

    public String breakLines(String text) {
        if (text == null) {
            return null;
        }
        if (text.startsWith("<html>")) {
            return text;
        }
        int i = 0;
        while (i < this.indent - this.label.length()) {
            this.outText.append(" ");
            ++i;
        }
        StringBuilder word = new StringBuilder();
        this.pos = this.indent;
        boolean lastLineBreak = false;
        int i2 = 0;
        while (i2 < text.length()) {
            char c = text.charAt(i2);
            switch (c) {
                case '\n': {
                    if (this.preserveLineBreaks || lastLineBreak) {
                        this.addWord(word);
                        this.lineBreak();
                        break;
                    }
                    this.addWord(word);
                    lastLineBreak = true;
                    break;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    this.addWord(word);
                    lastLineBreak = false;
                    break;
                }
                default: {
                    word.append(c);
                    lastLineBreak = false;
                }
            }
            ++i2;
        }
        this.addWord(word);
        String ret = this.outText.toString();
        if (this.toHTML) {
            ret = "<html>" + ret.replace("<", "&lt;").replace(">", "&gt;") + "</html>";
            if (this.lines > 1) {
                ret = ret.replace("\n", "<br>");
            }
        }
        return ret;
    }

    private void addWord(StringBuilder word) {
        if (word.length() > 0) {
            if (this.lines == 0) {
                this.lines = 1;
            }
            if (this.pos + (this.isFirst ? word.length() : word.length() + 1) > this.cols) {
                this.lineBreak();
            } else if (!this.isFirst) {
                this.outText.append(" ");
                ++this.pos;
            }
            this.outText.append((CharSequence)word);
            this.pos += word.length();
            word.setLength(0);
            this.isFirst = false;
        }
    }

    private void lineBreak() {
        if (!this.isFirst) {
            this.outText.append(this.lineBreak);
            int j = 0;
            while (j < this.indent) {
                this.outText.append(" ");
                ++j;
            }
            this.pos = this.indent;
            this.isFirst = true;
            ++this.lines;
        }
    }

    public LineBreaker preserveContainedLineBreaks() {
        this.preserveLineBreaks = true;
        return this;
    }

    public LineBreaker toHTML() {
        this.toHTML = true;
        return this;
    }

    public int getLineCount() {
        return this.lines;
    }
}

