/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.analyse.ModelAnalyser;
import de.neemann.digital.core.BacktrackException;
import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.NodeWithoutDelay;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Observer;
import de.neemann.digital.core.Signal;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyAnalyser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyAnalyser.class);
    private final HashMap<Signal, Set<ObservableValue>> dependencyMap = new HashMap();
    private int maxDepth;

    public DependencyAnalyser(ModelAnalyser modelAnalyser) throws BacktrackException, PinException {
        for (Signal s : modelAnalyser.getInputs()) {
            HashSet<ObservableValue> effected = new HashSet<ObservableValue>();
            this.backtracking(s.getValue(), effected, 0);
            this.dependencyMap.put(s, effected);
        }
        LOGGER.info("circuit max depth: " + this.getMaxPathLen());
    }

    public ArrayList<Signal> getInputs(Signal output) {
        ArrayList<Signal> list = new ArrayList<Signal>();
        for (Map.Entry<Signal, Set<ObservableValue>> e : this.dependencyMap.entrySet()) {
            if (!e.getValue().contains(output.getValue())) continue;
            list.add(e.getKey());
        }
        return list;
    }

    public long getRequiredSteps(ModelAnalyser modelAnalyser) {
        long num = 0L;
        for (Signal o : modelAnalyser.getOutputs()) {
            int n = this.getInputs(o).size();
            num += 1L << n;
        }
        return num;
    }

    private void backtracking(ObservableValue value, Set<ObservableValue> effected, int depth) throws PinException, BacktrackException {
        if (depth > this.maxDepth) {
            this.maxDepth = depth;
        }
        if (!effected.contains(value)) {
            effected.add(value);
            for (Observer o : value.getObservers()) {
                if (o instanceof NodeInterface) {
                    ObservableValues outputs = ((NodeInterface)o).getOutputs();
                    int d = depth;
                    if (!(o instanceof NodeWithoutDelay)) {
                        ++d;
                    }
                    for (ObservableValue co : outputs) {
                        this.backtracking(co, effected, d);
                    }
                    continue;
                }
                throw new BacktrackException(Lang.get("err_backtrackOf_N_isImpossible", o.getClass().getSimpleName()));
            }
        }
    }

    public int getMaxPathLen() {
        return this.maxDepth;
    }
}

