/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.Signal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

public class ModelAnalyserInfo {
    private final String clockPin;
    private final ArrayList<Bus> inputBusList;
    private final ArrayList<Bus> outputBusList;
    private final HashMap<String, Long> initValueMap;
    private final boolean isSequential;
    private TreeMap<String, String> pins;
    private ArrayList<Signal> inputs;
    private ArrayList<Signal> outputs;
    private ArrayList<String> pinsWithoutNumber;
    private String stateSignalName;
    private ArrayList<String> stateSignalBitNames;

    public ModelAnalyserInfo(Model model) {
        this.clockPin = model != null && model.getClocks().size() == 1 ? model.getClocks().get(0).getClockPin() : null;
        this.isSequential = model != null && !model.findNode(Node::hasState).isEmpty();
        this.inputBusList = new ArrayList();
        this.outputBusList = new ArrayList();
        this.initValueMap = new HashMap();
    }

    public void setInOut(ArrayList<Signal> inputs, ArrayList<Signal> outputs) {
        this.inputs = new ArrayList<Signal>(inputs);
        this.outputs = new ArrayList<Signal>(outputs);
    }

    public TreeMap<String, String> getPins() {
        if (this.pins == null) {
            this.pins = new TreeMap();
            for (Signal s : this.inputs) {
                this.addPinNumber(s);
            }
            for (Signal s : this.outputs) {
                this.addPinNumber(s);
            }
        }
        return this.pins;
    }

    private void addPinNumber(Signal s) {
        String p = s.getPinNumber();
        if (p != null && p.length() > 0) {
            this.pins.put(s.getName(), p);
        }
    }

    public ArrayList<String> getPinsWithoutNumber() {
        if (this.pinsWithoutNumber == null) {
            this.pinsWithoutNumber = new ArrayList();
            for (Signal s : this.inputs) {
                if (!s.missingPinNumber()) continue;
                this.pinsWithoutNumber.add(s.getName());
            }
            for (Signal s : this.outputs) {
                if (!s.missingPinNumber()) continue;
                this.pinsWithoutNumber.add(s.getName());
            }
        }
        return this.pinsWithoutNumber;
    }

    public int getClockPinInt() {
        if (this.clockPin == null || this.clockPin.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(this.clockPin);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    void addInputBus(String name, ArrayList<String> names) {
        for (Bus b : this.inputBusList) {
            if (!b.getBusName().equals(name)) continue;
            return;
        }
        this.inputBusList.add(new Bus(name, names));
    }

    public void addOutputBus(String name, ArrayList<String> names) {
        for (Bus b : this.outputBusList) {
            if (!b.getBusName().equals(name)) continue;
            return;
        }
        this.outputBusList.add(new Bus(name, names));
    }

    public ArrayList<Bus> getInputBusList() {
        return this.inputBusList;
    }

    public ArrayList<Bus> getOutputBusList() {
        return this.outputBusList;
    }

    public boolean isSequential() {
        return this.isSequential;
    }

    public long getSequentialInitValue(String name) {
        Long init = this.initValueMap.get(name);
        if (init == null) {
            return 0L;
        }
        return init;
    }

    public void setSequentialInitValue(String name, long value) {
        this.initValueMap.put(name, value);
    }

    public String getStateSignalName() {
        return this.stateSignalName;
    }

    public void setStateSignalName(String stateSignalName) {
        this.stateSignalName = stateSignalName;
    }

    public void setStateSignalBitNames(ArrayList<String> stateSignalBitName) {
        this.stateSignalBitNames = stateSignalBitName;
    }

    public ArrayList<String> getStateSignalBitNames() {
        return this.stateSignalBitNames;
    }

    public static final class Bus {
        private final String busName;
        private final ArrayList<String> signalNames;

        private Bus(String busName, ArrayList<String> signalNames) {
            this.busName = busName;
            this.signalNames = signalNames;
        }

        public String getBusName() {
            return this.busName;
        }

        public ArrayList<String> getSignalNames() {
            return this.signalNames;
        }
    }
}

