/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.core.Signal;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SplitPinString {
    private static final SplitPinString EMPTY = new SplitPinString();

    public static SplitPinString create(Signal s) {
        if (s.missingPinNumber()) {
            return EMPTY;
        }
        return SplitPinString.create(s.getPinNumber());
    }

    public static SplitPinString create(String pinStr) {
        if (pinStr == null || pinStr.trim().length() == 0) {
            return EMPTY;
        }
        StringTokenizer st = new StringTokenizer(pinStr, ",;");
        ArrayList<String> pins = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            pins.add(st.nextToken().trim());
        }
        return new PinsArray(pins);
    }

    private SplitPinString() {
    }

    public String getPin(int i) {
        return null;
    }

    /* synthetic */ SplitPinString(SplitPinString splitPinString) {
        this();
    }

    private static final class PinsArray
    extends SplitPinString {
        private final ArrayList<String> pins;

        private PinsArray(ArrayList<String> pins) {
            super(null);
            this.pins = pins;
        }

        @Override
        public String getPin(int i) {
            if (i >= this.pins.size()) {
                return null;
            }
            return this.pins.get(i);
        }
    }
}

