/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import de.neemann.digital.XStreamValid;
import de.neemann.digital.analyse.BoolTableExpanded;
import de.neemann.digital.analyse.CSVImporter;
import de.neemann.digital.analyse.ModelAnalyserInfo;
import de.neemann.digital.analyse.TruthTableConverter;
import de.neemann.digital.analyse.expression.BitSetter;
import de.neemann.digital.analyse.expression.Context;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.BoolTableByteArray;
import de.neemann.digital.undo.Copyable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;

public class TruthTable
implements Copyable<TruthTable> {
    private final ArrayList<Variable> variables;
    private final ArrayList<Result> results;
    private transient BitSetter bitSetter;
    private transient ModelAnalyserInfo modelAnalyzerInfo;

    public static TruthTable readFromFile(File filename) throws IOException {
        if (filename.getName().toLowerCase().endsWith(".csv")) {
            return CSVImporter.readCSV(filename);
        }
        XStream xStream = TruthTable.getxStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(filename);){
            return (TruthTable)xStream.fromXML(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void save(File filename) throws IOException {
        XStream xStream = TruthTable.getxStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8);){
            out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            xStream.marshal(this, new PrettyPrintWriter(out));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static XStream getxStream() {
        XStreamValid xStream = new XStreamValid();
        xStream.alias("truthTable", TruthTable.class);
        xStream.alias("variable", Variable.class);
        xStream.aliasAttribute(Variable.class, "identifier", "name");
        xStream.alias("result", Result.class);
        xStream.alias("BoolTable", BoolTableByteArray.class);
        xStream.alias("BoolTableEx", BoolTableExpanded.class);
        xStream.registerConverter(new TruthTableConverter());
        return xStream;
    }

    public TruthTable() {
        this(new ArrayList<Variable>());
    }

    public TruthTable(int vars) {
        this(Variable.vars(vars));
    }

    public TruthTable(ArrayList<Variable> vars) {
        this.variables = vars;
        this.results = new ArrayList();
    }

    public TruthTable(ArrayList<Variable> newVars, TruthTable oldTable) {
        this(newVars);
        int i = 0;
        while (i < oldTable.getResultCount()) {
            this.addResult(oldTable.results.get(i).getName(), new BoolTableByteArray(this.getRows()));
            ++i;
        }
    }

    private TruthTable(TruthTable truthTable) {
        this.variables = new ArrayList(truthTable.variables.size());
        for (Variable v : truthTable.variables) {
            this.variables.add(new Variable(v.getIdentifier()));
        }
        this.results = new ArrayList();
        int i = 0;
        while (i < truthTable.getResultCount()) {
            Result result = truthTable.results.get(i);
            this.addResult(result.getName(), new BoolTableByteArray(result.values));
            ++i;
        }
        this.modelAnalyzerInfo = truthTable.modelAnalyzerInfo;
    }

    public void clear(Collection<? extends Variable> vars) {
        this.variables.clear();
        this.variables.addAll(vars);
        this.results.clear();
        this.bitSetter = null;
    }

    public int getRows() {
        return 1 << this.variables.size();
    }

    public TruthTable addResult(String name, BoolTable values) {
        this.results.add(new Result(name, values));
        return this;
    }

    public TruthTable addResult() {
        String var;
        char v = 'Y';
        do {
            var = "" + v;
            v = (char)(v - '\u0001');
        } while (this.resultsContains(var) && v >= 81);
        return this.addResult(var);
    }

    public TruthTable addResult(String name) {
        this.results.add(new Result(name, new BoolTableByteArray(this.getRows())));
        return this;
    }

    private boolean resultsContains(String var) {
        for (Result r : this.results) {
            if (!r.getName().equals(var)) continue;
            return true;
        }
        return false;
    }

    public void addVariable() {
        Variable var;
        char v = 'A';
        do {
            var = new Variable("" + v);
            v = (char)(v + '\u0001');
        } while (this.variables.contains(var) && v <= 90);
        this.addVariable(var);
    }

    public TruthTable addVariable(String name) {
        return this.addVariable(new Variable(name));
    }

    public TruthTable addVariable(Variable var) {
        this.variables.add(var);
        for (Result r : this.results) {
            r.setValues(BoolTableByteArray.createDoubledValues(r.getValues()));
        }
        this.bitSetter = null;
        return this;
    }

    private BitSetter getBitSetter() {
        if (this.bitSetter == null) {
            this.bitSetter = new DummyBitSetter(this.variables.size());
        }
        return this.bitSetter;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Variable variable : this.variables) {
            sb.append(variable.getIdentifier()).append("\t");
        }
        for (Result result : this.results) {
            sb.append(result.getName()).append("\t");
        }
        if (this.getRows() <= 256) {
            void var2_8;
            sb.append('\n');
            boolean bl = false;
            while (var2_8 < this.getRows()) {
                int col = 0;
                while (col < this.variables.size()) {
                    if (this.getBitSetter().getBit((int)var2_8, col)) {
                        sb.append("1\t");
                    } else {
                        sb.append("0\t");
                    }
                    ++col;
                }
                col = 0;
                while (col < this.results.size()) {
                    switch (this.results.get(col).getValues().get((int)var2_8)) {
                        case one: {
                            sb.append("1\t");
                            break;
                        }
                        case zero: {
                            sb.append("0\t");
                            break;
                        }
                        default: {
                            sb.append("x\t");
                        }
                    }
                    ++col;
                }
                sb.append("\n");
                ++var2_8;
            }
        }
        return sb.toString();
    }

    public int getCols() {
        return this.variables.size() + this.results.size();
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < this.variables.size()) {
            return this.variables.get(columnIndex).getIdentifier();
        }
        return this.results.get(columnIndex - this.variables.size()).getName();
    }

    public int getValue(int rowIndex, int columnIndex) {
        if (columnIndex < this.variables.size()) {
            if (this.getBitSetter().getBit(rowIndex, columnIndex)) {
                return 1;
            }
            return 0;
        }
        return this.results.get(columnIndex - this.variables.size()).getValues().get(rowIndex).asInt();
    }

    public boolean isEditable(int columnIndex) {
        if (columnIndex < this.variables.size()) {
            return false;
        }
        BoolTable v = this.results.get(columnIndex - this.variables.size()).getValues();
        return v instanceof BoolTableByteArray;
    }

    public void setValue(int rowIndex, int columnIndex, int aValue) {
        BoolTable v;
        if (columnIndex >= this.variables.size() && (v = this.results.get(columnIndex - this.variables.size()).getValues()) instanceof BoolTableByteArray) {
            ((BoolTableByteArray)v).set(rowIndex, aValue);
        }
    }

    public void setColumnName(int columnIndex, String name) {
        if (columnIndex < this.variables.size()) {
            this.variables.set(columnIndex, new Variable(name));
        } else {
            this.results.get(columnIndex - this.variables.size()).setName(name);
        }
    }

    public ArrayList<Variable> getVars() {
        return this.variables;
    }

    public int getByContext(int result, Context context) throws ExpressionException {
        return this.results.get(result).getValues().get(this.getIndexByContext(context)).asInt();
    }

    public void setByContext(int result, Context context, int value) throws ExpressionException {
        BoolTable v = this.results.get(result).getValues();
        if (v instanceof BoolTableByteArray) {
            ((BoolTableByteArray)v).set(this.getIndexByContext(context), value);
        }
    }

    private int getIndexByContext(Context context) throws ExpressionException {
        int mask = 1 << this.variables.size() - 1;
        int index = 0;
        int i = 0;
        while (i < this.variables.size()) {
            if (context.get(this.variables.get(i))) {
                index |= mask;
            }
            mask >>= 1;
            ++i;
        }
        return index;
    }

    public int getResultCount() {
        return this.results.size();
    }

    public BoolTable getResult(int result) {
        return this.results.get(result).getValues();
    }

    public BoolTable getResult(String resultName) {
        for (Result r : this.results) {
            if (!r.getName().equals(resultName)) continue;
            return r.getValues();
        }
        return null;
    }

    public String getResultName(int result) {
        return this.results.get(result).getName();
    }

    public void removeResult(int i) {
        this.results.remove(i);
    }

    public TruthTable modifyValues(BoolTableByteArray.TableModifier m) {
        for (Result r : this.results) {
            BoolTable bt = r.getValues();
            if (!(bt instanceof BoolTableByteArray)) continue;
            ((BoolTableByteArray)bt).modify(m);
        }
        return this;
    }

    public void setModelAnalyzerInfo(ModelAnalyserInfo modelAnalyzerInfo) {
        this.modelAnalyzerInfo = modelAnalyzerInfo;
    }

    public ModelAnalyserInfo getModelAnalyzerInfo() {
        return this.modelAnalyzerInfo;
    }

    @Override
    public TruthTable createDeepCopy() {
        return new TruthTable(this);
    }

    public ArrayList<String> getVarNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Variable v : this.variables) {
            names.add(v.getIdentifier());
        }
        return names;
    }

    public ArrayList<String> getResultNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Result r : this.results) {
            names.add(r.getName());
        }
        return names;
    }

    private static final class DummyBitSetter
    extends BitSetter {
        private DummyBitSetter(int bitCount) {
            super(bitCount);
        }

        @Override
        public void setBit(int row, int bit, boolean value) {
        }
    }

    private static final class Result {
        private String name;
        private BoolTable values;

        Result(String name, BoolTable values) {
            this.name = name;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public BoolTable getValues() {
            return this.values;
        }

        public void setValues(BoolTable values) {
            this.values = values;
        }
    }
}

