/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression;

import de.neemann.digital.analyse.expression.Context;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionVisitor;

public final class Constant
implements Expression {
    private final boolean value;
    public static final Constant ONE = new Constant(true);
    public static final Constant ZERO = new Constant(false);

    private Constant(boolean value) {
        this.value = value;
    }

    @Override
    public boolean calculate(Context context) {
        return this.value;
    }

    @Override
    public <V extends ExpressionVisitor> V traverse(V v) {
        v.visit(this);
        return v;
    }

    @Override
    public String getOrderString() {
        return Boolean.toString(this.value);
    }

    public boolean getValue() {
        return this.value;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public Expression copy() {
        return this;
    }
}

