/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression;

import de.neemann.digital.analyse.expression.Context;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.ExpressionVisitor;

public class NamedExpression
implements Expression {
    private final Expression exp;
    private final String name;

    public NamedExpression(String name, Expression exp) {
        this.exp = exp;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.exp;
    }

    @Override
    public boolean calculate(Context context) throws ExpressionException {
        return this.exp.calculate(context);
    }

    @Override
    public <V extends ExpressionVisitor> V traverse(V visitor) {
        return this.exp.traverse(visitor);
    }

    @Override
    public String getOrderString() {
        return this.exp.getOrderString();
    }

    @Override
    public Expression copy() {
        return new NamedExpression(this.name, this.exp.copy());
    }

    public String toString() {
        return String.valueOf(this.name) + "=" + this.exp.toString();
    }
}

