/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression.format;

import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.format.FormatToTable;
import de.neemann.digital.draw.graphics.text.formatter.LaTeXFormatter;

public class FormatToTableLatex
extends FormatToTable {
    @Override
    protected void formatHead(StringBuilder sb, int varCount) {
        sb.append("\\begin{tabular}{");
        int i = 0;
        while (i < varCount) {
            sb.append("c");
            ++i;
        }
        sb.append("|c}\n");
    }

    @Override
    protected String formatVariable(Variable v) {
        return "$" + LaTeXFormatter.format(v) + "$&";
    }

    @Override
    protected String formatResultVariable() {
        return "$Y$\\\\";
    }

    @Override
    protected void formatTableStart(StringBuilder sb) {
        sb.append("\\hline\n");
    }

    @Override
    protected String formatValue(boolean val) {
        return String.valueOf(super.formatValue(val)) + "&";
    }

    @Override
    protected String formatResult(boolean value) {
        return String.valueOf(super.formatValue(value)) + "\\\\";
    }

    @Override
    protected void formatEnd(StringBuilder sb) {
        sb.append("\\end{tabular}\n");
    }
}

