/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression.modify;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.modify.ExpressionModifier;
import java.util.ArrayList;

public class NInputs
implements ExpressionModifier {
    private final int inputs;

    public NInputs(int inputs) {
        this.inputs = inputs;
    }

    @Override
    public Expression modify(Expression expression) {
        Operation op;
        if (expression instanceof Operation && (op = (Operation)expression).getExpressions().size() > this.inputs) {
            if (expression instanceof Operation.And) {
                return this.generate(op.getExpressions(), expressionArray -> Operation.andNoMerge(expressionArray));
            }
            if (expression instanceof Operation.Or) {
                return this.generate(op.getExpressions(), expressionArray -> Operation.orNoMerge(expressionArray));
            }
        }
        return expression;
    }

    private Expression generate(ArrayList<Expression> list, OpGen op) {
        if (list.size() <= this.inputs) {
            return op.op(list.toArray(new Expression[0]));
        }
        ArrayList<Expression> resList = new ArrayList<Expression>();
        int desiredSize = this.inputs;
        int res = list.size() % this.inputs;
        if (res != 0) {
            desiredSize = (res + this.inputs) / 2;
        }
        ArrayList<Expression> iList = new ArrayList<Expression>();
        for (Expression e : list) {
            iList.add(e);
            if (iList.size() != desiredSize) continue;
            resList.add(op.op(iList.toArray(new Expression[0])));
            desiredSize = this.inputs;
            iList.clear();
        }
        if (iList.size() > 0) {
            resList.add(op.op(iList.toArray(new Expression[0])));
        }
        return this.generate(resList, op);
    }

    private static interface OpGen {
        public Expression op(Expression ... var1);
    }
}

