/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.format;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.format.TruthTableFormatter;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;
import de.neemann.digital.lang.Lang;

public class TruthTableFormatterHex
implements TruthTableFormatter {
    @Override
    public String format(TruthTable truthTable) throws ExpressionException {
        if (truthTable.getResultCount() > 63) {
            throw new ExpressionException(Lang.get("err_tableHasToManyResultColumns", new Object[0]));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("v2.0 raw\n");
        int count = truthTable.getResult(0).size();
        int i = 0;
        while (i < count) {
            long val = 0L;
            long mask = 1L;
            int j = 0;
            while (j < truthTable.getResultCount()) {
                ThreeStateValue v = truthTable.getResult(j).get(i);
                if (v == ThreeStateValue.one) {
                    val |= mask;
                }
                mask *= 2L;
                ++j;
            }
            sb.append(Long.toHexString(val));
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }
}

