/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.quinemc;

import de.neemann.digital.analyse.quinemc.TableRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class TableRows
implements Iterable<TableRow> {
    private final TreeMap<Long, InnerList> rows = new TreeMap();
    private int size;

    public int size() {
        return this.size;
    }

    public void add(TableRow tableRow) {
        long flags = tableRow.getOptimizedFlags();
        this.getList(flags).add(tableRow);
        ++this.size;
    }

    private InnerList getList(long flags) {
        InnerList list = this.rows.get(flags);
        if (list == null) {
            list = new InnerList();
            this.rows.put(flags, list);
        }
        return list;
    }

    public void clear() {
        this.rows.clear();
        this.size = 0;
    }

    public void addAll(TableRows newRows) {
        for (Map.Entry<Long, InnerList> e : newRows.rows.entrySet()) {
            InnerList values = e.getValue();
            this.getList(e.getKey()).addAll(values);
            this.size += values.size();
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(TableRow r) {
        InnerList list = this.rows.get(r.getOptimizedFlags());
        if (list == null) {
            return false;
        }
        return list.contains(r);
    }

    @Override
    public Iterator<TableRow> iterator() {
        return new RowIterator(this.rows.values().iterator());
    }

    public Iterable<InnerList> listIterable() {
        return this.rows.values();
    }

    public TableRow get(int i) {
        for (Map.Entry<Long, InnerList> e : this.rows.entrySet()) {
            InnerList list = e.getValue();
            if (i < list.size()) {
                return list.get(i);
            }
            i -= list.size();
        }
        throw new IndexOutOfBoundsException();
    }

    public static final class InnerList
    implements Iterable<TableRow> {
        private ArrayList<TableRow> innerList = new ArrayList();

        private InnerList() {
        }

        public boolean contains(TableRow r) {
            return this.innerList.contains(r);
        }

        public void addAll(InnerList values) {
            for (TableRow tr : values) {
                this.add(tr);
            }
        }

        public void add(TableRow tableRow) {
            this.innerList.add(tableRow);
        }

        public int size() {
            return this.innerList.size();
        }

        public TableRow get(int i) {
            return this.innerList.get(i);
        }

        @Override
        public Iterator<TableRow> iterator() {
            return this.innerList.iterator();
        }
    }

    private static class RowIterator
    implements Iterator<TableRow> {
        private final Iterator<InnerList> listIter;
        private Iterator<TableRow> itemIter;

        RowIterator(Iterator<InnerList> iterator) {
            this.listIter = iterator;
            this.itemIter = null;
        }

        @Override
        public boolean hasNext() {
            while (this.itemIter == null && this.listIter.hasNext()) {
                this.itemIter = this.listIter.next().iterator();
                if (this.itemIter.hasNext()) continue;
                this.itemIter = null;
            }
            return this.itemIter != null;
        }

        @Override
        public TableRow next() {
            TableRow next = this.itemIter.next();
            if (!this.itemIter.hasNext()) {
                this.itemIter = null;
            }
            return next;
        }
    }
}

