/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.modify.ExpressionModifier;
import de.neemann.digital.builder.BuilderException;
import de.neemann.digital.builder.BuilderInterface;
import de.neemann.digital.builder.PinMap;
import de.neemann.digital.builder.PinMapException;
import java.util.HashMap;

public class CleanNameBuilder
implements BuilderInterface<CleanNameBuilder> {
    private BuilderInterface parent;
    private final Filter filter;
    private final HashMap<String, String> nameMap;

    public CleanNameBuilder(BuilderInterface parent) {
        this(parent, new SimpleFilter());
    }

    public CleanNameBuilder(BuilderInterface parent, Filter filter) {
        this.parent = parent;
        this.filter = filter;
        this.nameMap = new HashMap();
    }

    @Override
    public CleanNameBuilder addCombinatorial(String name, Expression expression) throws BuilderException {
        this.parent.addCombinatorial(this.checkName(name), this.checkName(expression));
        return this;
    }

    @Override
    public CleanNameBuilder addSequential(String name, Expression expression) throws BuilderException {
        this.parent.addSequential(this.checkName(name), this.checkName(expression));
        return this;
    }

    private Expression checkName(Expression expression) {
        return ExpressionModifier.modifyExpression(expression, exp -> {
            if (exp instanceof Variable) {
                return new Variable(this.checkName(((Variable)exp).getIdentifier()));
            }
            return exp;
        });
    }

    private String checkName(String name) {
        String n = this.nameMap.get(name);
        if (n == null) {
            n = this.filter.filter(name);
            if (n == null || n.isEmpty()) {
                n = "X";
            }
            if (this.nameMap.containsValue(n)) {
                int num = 1;
                while (this.nameMap.containsValue(String.valueOf(n) + num)) {
                    ++num;
                }
                n = String.valueOf(n) + num;
            }
            this.nameMap.put(name, n);
        }
        return n;
    }

    public PinMap createPinMap() {
        return new PinMap(){

            @Override
            public PinMap assignPin(String name, int pin) throws PinMapException {
                return super.assignPin(CleanNameBuilder.this.checkName(name), pin);
            }
        };
    }

    public void setParent(BuilderInterface parent) {
        this.parent = parent;
    }

    public static interface Filter {
        public String filter(String var1);
    }

    private static final class SimpleFilter
    implements Filter {
        private SimpleFilter() {
        }

        @Override
        public String filter(String name) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < name.length()) {
                char c = name.charAt(i);
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

