/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.circuit;

import de.neemann.digital.analyse.DetermineJKStateMachine;
import de.neemann.digital.analyse.ModelAnalyserInfo;
import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.ContextFiller;
import de.neemann.digital.analyse.expression.Equals;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.NamedExpression;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.VariableVisitor;
import de.neemann.digital.builder.BuilderException;
import de.neemann.digital.builder.BuilderInterface;
import de.neemann.digital.builder.circuit.Box;
import de.neemann.digital.builder.circuit.Fragment;
import de.neemann.digital.builder.circuit.FragmentExpression;
import de.neemann.digital.builder.circuit.FragmentSameInValue;
import de.neemann.digital.builder.circuit.FragmentVariable;
import de.neemann.digital.builder.circuit.FragmentVisitor;
import de.neemann.digital.builder.circuit.FragmentVisualElement;
import de.neemann.digital.core.basic.And;
import de.neemann.digital.core.basic.NAnd;
import de.neemann.digital.core.basic.NOr;
import de.neemann.digital.core.basic.Not;
import de.neemann.digital.core.basic.Or;
import de.neemann.digital.core.basic.XNOr;
import de.neemann.digital.core.basic.XOr;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.Rotation;
import de.neemann.digital.core.flipflops.FlipflopD;
import de.neemann.digital.core.flipflops.FlipflopJK;
import de.neemann.digital.core.io.Const;
import de.neemann.digital.core.io.In;
import de.neemann.digital.core.io.Out;
import de.neemann.digital.core.io.Probe;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.LookUpTable;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.core.wiring.Splitter;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Tunnel;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class CircuitBuilder
implements BuilderInterface<CircuitBuilder> {
    private final VariableVisitor variableVisitor;
    private final ShapeFactory shapeFactory;
    private final ArrayList<FragmentVariable> fragmentVariables;
    private final ArrayList<Fragment> fragments;
    private final HashMap<String, FragmentVisualElement> combinatorialOutputs;
    private final ArrayList<Variable> sequentialVars;
    private final ArrayList<FragmentVisualElement> flipflops;
    private final ArrayList<Variable> desiredVarOrdering;
    private final HashSet<String> varsToNet;
    private final HashSet<String> localVarsUsed;
    private int pos;
    private boolean useLUT;
    private boolean useJKff;
    private ModelAnalyserInfo mai;
    private int lutNumber;
    private boolean resolveLocalVars;
    private boolean wideShapes;

    public CircuitBuilder(ShapeFactory shapeFactory) {
        this(shapeFactory, null);
    }

    public CircuitBuilder(ShapeFactory shapeFactory, ArrayList<Variable> varOrdering) {
        this.shapeFactory = shapeFactory;
        this.useJKff = false;
        this.useLUT = false;
        this.desiredVarOrdering = varOrdering;
        this.variableVisitor = new VariableVisitor();
        this.fragmentVariables = new ArrayList();
        this.fragments = new ArrayList();
        this.flipflops = new ArrayList();
        this.combinatorialOutputs = new HashMap();
        this.sequentialVars = new ArrayList();
        this.varsToNet = new HashSet();
        this.localVarsUsed = new HashSet();
        this.wideShapes = Settings.getInstance().get(Keys.SETTINGS_IEEE_SHAPES);
    }

    public CircuitBuilder setResolveLocalVars(boolean resolveLocalVars) {
        this.resolveLocalVars = resolveLocalVars;
        return this;
    }

    public CircuitBuilder setUseJK(boolean useJKff) {
        this.useJKff = useJKff;
        return this;
    }

    public CircuitBuilder setUseLUTs(boolean useLUT) {
        this.useLUT = useLUT;
        return this;
    }

    public CircuitBuilder setWideShapes(boolean wideShapes) {
        this.wideShapes = wideShapes;
        return this;
    }

    @Override
    public CircuitBuilder addCombinatorial(String name, Expression expression) throws BuilderException {
        if (expression instanceof NamedExpression) {
            name = ((NamedExpression)expression).getName();
            expression = ((NamedExpression)expression).getExpression();
        }
        Fragment fr = this.createFragment(expression);
        FragmentVisualElement frag = new FragmentVisualElement(Out.DESCRIPTION, this.shapeFactory).setAttr(Keys.LABEL, name);
        this.checkPinNumber(frag.getVisualElement());
        this.checkForLocalVars(expression);
        this.combinatorialOutputs.put(name, frag);
        this.fragments.add(new FragmentExpression(fr, (Fragment)frag));
        expression.traverse(this.variableVisitor);
        return this;
    }

    void checkForLocalVars(Expression expression) {
        VariableVisitor vv = new VariableVisitor();
        expression.traverse(vv);
        for (Variable usedVar : vv.getVariables()) {
            for (String createdVar : this.combinatorialOutputs.keySet()) {
                if (!usedVar.getIdentifier().equals(createdVar)) continue;
                this.localVarsUsed.add(createdVar);
            }
        }
    }

    @Override
    public CircuitBuilder addSequential(String name, Expression expression) throws BuilderException {
        boolean useDff = true;
        long initValue = 0L;
        if (this.mai != null) {
            initValue = this.mai.getSequentialInitValue(name);
        }
        if (this.useJKff) {
            try {
                DetermineJKStateMachine jk = new DetermineJKStateMachine(name, expression);
                useDff = jk.isDFF();
                if (!useDff) {
                    boolean isJequalK = new Equals(jk.getSimplifiedJ(), jk.getSimplifiedK()).isEqual();
                    Fragment frJ = this.createFragment(jk.getSimplifiedJ());
                    if (isJequalK) {
                        FragmentVisualElement ff = new FragmentVisualElement(FlipflopJK.DESCRIPTION, this.shapeFactory).ignoreInput(1).setAttr(Keys.LABEL, name).setAttr(Keys.DEFAULT, initValue);
                        this.flipflops.add(ff);
                        FragmentSameInValue fsv = new FragmentSameInValue(ff);
                        FragmentExpression fe = new FragmentExpression(fsv, (Fragment)new FragmentVisualElement(Tunnel.DESCRIPTION, this.shapeFactory).setAttr(Keys.NETNAME, name));
                        this.fragments.add(new FragmentExpression(frJ, (Fragment)fe));
                    } else {
                        Fragment frK = this.createFragment(jk.getSimplifiedK());
                        FragmentVisualElement ff = new FragmentVisualElement(FlipflopJK.DESCRIPTION, this.shapeFactory).ignoreInput(1).setAttr(Keys.LABEL, name).setAttr(Keys.DEFAULT, initValue);
                        this.flipflops.add(ff);
                        FragmentExpression fe = new FragmentExpression(ff, (Fragment)new FragmentVisualElement(Tunnel.DESCRIPTION, this.shapeFactory).setAttr(Keys.NETNAME, name));
                        this.fragments.add(new FragmentExpression(Arrays.asList(frJ, frK), (Fragment)fe));
                    }
                }
            }
            catch (ExpressionException e) {
                throw new BuilderException(e.getMessage());
            }
        }
        if (useDff) {
            Fragment fe;
            Fragment fr = this.createFragment(expression);
            if (expression instanceof Constant) {
                fe = new FragmentVisualElement(Tunnel.DESCRIPTION, this.shapeFactory).setAttr(Keys.NETNAME, name);
            } else {
                FragmentVisualElement ff = new FragmentVisualElement(FlipflopD.DESCRIPTION, this.shapeFactory).setAttr(Keys.LABEL, name).setAttr(Keys.DEFAULT, initValue);
                this.flipflops.add(ff);
                fe = new FragmentExpression(ff, (Fragment)new FragmentVisualElement(Tunnel.DESCRIPTION, this.shapeFactory).setAttr(Keys.NETNAME, name));
            }
            this.fragments.add(new FragmentExpression(fr, fe));
        }
        this.checkForLocalVars(expression);
        expression.traverse(this.variableVisitor);
        this.sequentialVars.add(new Variable(name));
        return this;
    }

    private Fragment createFragment(Expression expression) throws BuilderException {
        if (this.useLUT) {
            if (Variable.isVarOrNotVar(expression) || expression instanceof Constant) {
                return this.createBasicFragment(expression);
            }
            if (expression instanceof Operation) {
                boolean allVars = true;
                for (Expression ex : ((Operation)expression).getExpressions()) {
                    if (Variable.isVarOrNotVar(ex)) continue;
                    allVars = false;
                }
                if (allVars) {
                    return this.createBasicFragment(expression);
                }
            }
            return this.createLutFragment(expression);
        }
        return this.createBasicFragment(expression);
    }

    private Fragment createLutFragment(Expression expression) throws BuilderException {
        ArrayList<Variable> vars = new ArrayList<Variable>(expression.traverse(new VariableVisitor()).getVariables());
        ArrayList<Fragment> frags = new ArrayList<Fragment>();
        for (Variable v : vars) {
            FragmentVariable fragmentVariable = new FragmentVariable(v, false);
            this.fragmentVariables.add(fragmentVariable);
            frags.add(0, fragmentVariable);
        }
        int size = 1 << vars.size();
        DataField data = new DataField(size);
        ContextFiller context = new ContextFiller(vars);
        int i = 0;
        while (i < size) {
            context.setContextTo(i);
            try {
                boolean r = expression.calculate(context);
                data.setData(i, r ? 1 : 0);
            }
            catch (ExpressionException e) {
                throw new BuilderException(Lang.get("err_builder_couldNotFillLUT", new Object[0]), e);
            }
            ++i;
        }
        if (CircuitBuilder.isXor(data.getData())) {
            return new FragmentExpression(frags, (Fragment)new FragmentVisualElement(XOr.DESCRIPTION, frags.size(), this.shapeFactory));
        }
        if (CircuitBuilder.isXNor(data.getData())) {
            return new FragmentExpression(frags, (Fragment)new FragmentVisualElement(XNOr.DESCRIPTION, frags.size(), this.shapeFactory));
        }
        ++this.lutNumber;
        return new FragmentExpression(frags, (Fragment)new FragmentVisualElement(LookUpTable.DESCRIPTION, frags.size(), this.shapeFactory).setAttr(Keys.LABEL, "L" + this.lutNumber).setAttr(Keys.INPUT_COUNT, frags.size()).setAttr(Keys.DATA, data).setAttr(Keys.BITS, 1));
    }

    static boolean isXNor(long[] data) {
        int i = 0;
        while (i < data.length) {
            if ((long)(Integer.bitCount(i) & 1) == data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean isXor(long[] data) {
        int i = 0;
        while (i < data.length) {
            if ((long)(Integer.bitCount(i) & 1) != data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Fragment createBasicFragment(Expression expression) throws BuilderException {
        if (expression instanceof Operation) {
            Operation op = (Operation)expression;
            ArrayList<Fragment> frags = this.getOperationFragments(op);
            if (op instanceof Operation.And) {
                return new FragmentExpression(frags, (Fragment)new FragmentVisualElement(And.DESCRIPTION, frags.size(), this.shapeFactory).setAttr(Keys.WIDE_SHAPE, this.wideShapes));
            }
            if (op instanceof Operation.Or) {
                return new FragmentExpression(frags, (Fragment)new FragmentVisualElement(Or.DESCRIPTION, frags.size(), this.shapeFactory).setAttr(Keys.WIDE_SHAPE, this.wideShapes));
            }
            if (op instanceof Operation.XOr) {
                return new FragmentExpression(frags, (Fragment)new FragmentVisualElement(XOr.DESCRIPTION, frags.size(), this.shapeFactory).setAttr(Keys.WIDE_SHAPE, this.wideShapes));
            }
            throw new BuilderException(Lang.get("err_builder_operationNotSupported", op.getClass().getSimpleName()));
        }
        if (expression instanceof de.neemann.digital.analyse.expression.Not) {
            de.neemann.digital.analyse.expression.Not n = (de.neemann.digital.analyse.expression.Not)expression;
            if (Variable.isVar(n.getExpression())) {
                FragmentVariable fragmentVariable = new FragmentVariable((Variable)n.getExpression(), true);
                this.fragmentVariables.add(fragmentVariable);
                return fragmentVariable;
            }
            if (n.getExpression() instanceof Operation.And) {
                ArrayList<Fragment> frags = this.getOperationFragments((Operation)n.getExpression());
                return new FragmentExpression(frags, (Fragment)new FragmentVisualElement(NAnd.DESCRIPTION, frags.size(), this.shapeFactory).setAttr(Keys.WIDE_SHAPE, this.wideShapes));
            }
            if (n.getExpression() instanceof Operation.Or) {
                ArrayList<Fragment> frags = this.getOperationFragments((Operation)n.getExpression());
                return new FragmentExpression(frags, (Fragment)new FragmentVisualElement(NOr.DESCRIPTION, frags.size(), this.shapeFactory).setAttr(Keys.WIDE_SHAPE, this.wideShapes));
            }
            if (n.getExpression() instanceof Operation.XOr) {
                ArrayList<Fragment> frags = this.getOperationFragments((Operation)n.getExpression());
                return new FragmentExpression(frags, (Fragment)new FragmentVisualElement(XNOr.DESCRIPTION, frags.size(), this.shapeFactory).setAttr(Keys.WIDE_SHAPE, this.wideShapes));
            }
            return new FragmentExpression(this.createBasicFragment(n.getExpression()), (Fragment)new FragmentVisualElement(Not.DESCRIPTION, this.shapeFactory));
        }
        if (Variable.isVar(expression)) {
            FragmentVariable fragmentVariable = new FragmentVariable((Variable)expression, false);
            this.fragmentVariables.add(fragmentVariable);
            return fragmentVariable;
        }
        if (expression instanceof Constant) {
            long val = 0L;
            if (((Constant)expression).getValue()) {
                val = 1L;
            }
            return new FragmentVisualElement(Const.DESCRIPTION, this.shapeFactory).setAttr(Keys.VALUE, val);
        }
        throw new BuilderException(Lang.get("err_builder_exprNotSupported", expression.getClass().getSimpleName()));
    }

    private ArrayList<Fragment> getOperationFragments(Operation op) throws BuilderException {
        ArrayList<Fragment> frags = new ArrayList<Fragment>();
        for (Expression exp : op.getExpressions()) {
            frags.add(this.createBasicFragment(exp));
        }
        return frags;
    }

    private void createInputBus(Collection<Variable> inputs, Circuit circuit) {
        HashMap<String, Integer> varPos = new HashMap<String, Integer>();
        int dx = -(inputs.size() * 3 - 1) * 20;
        this.pos -= 20;
        for (Variable v : inputs) {
            VisualElement visualElement;
            if (this.sequentialVars.contains(v) || this.varsToNet.contains(v.getIdentifier())) {
                visualElement = new VisualElement(Tunnel.DESCRIPTION.getName()).setShapeFactory(this.shapeFactory);
                visualElement.getElementAttributes().set(Keys.ROTATE, new Rotation(1)).set(Keys.NETNAME, v.getIdentifier());
            } else {
                visualElement = new VisualElement(In.DESCRIPTION.getName()).setShapeFactory(this.shapeFactory);
                visualElement.getElementAttributes().set(Keys.ROTATE, new Rotation(3)).set(Keys.LABEL, v.getIdentifier());
                this.checkPinNumber(visualElement);
                if (this.mai != null && this.mai.getStateSignalBitNames() != null && this.mai.getStateSignalBitNames().contains(v.getIdentifier())) {
                    VisualElement ve = new VisualElement(Tunnel.DESCRIPTION.getName()).setShapeFactory(this.shapeFactory);
                    ve.getElementAttributes().set(Keys.ROTATE, new Rotation(3)).set(Keys.NETNAME, v.getIdentifier());
                    ve.setPos(new Vector(dx, this.pos));
                    circuit.add(ve);
                }
            }
            visualElement.setPos(new Vector(dx, -100));
            circuit.add(visualElement);
            circuit.add(new Wire(new Vector(dx, -100), new Vector(dx, this.pos)));
            if (this.isNotNeeded(v.getIdentifier())) {
                visualElement = new VisualElement(Not.DESCRIPTION.getName()).setShapeFactory(this.shapeFactory);
                visualElement.getElementAttributes().set(Keys.ROTATE, new Rotation(3));
                visualElement.setPos(new Vector(dx + 20, -60));
                circuit.add(visualElement);
                circuit.add(new Wire(new Vector(dx, -80), new Vector(dx + 20, -80)));
                circuit.add(new Wire(new Vector(dx + 20, -60), new Vector(dx + 20, -80)));
                circuit.add(new Wire(new Vector(dx + 20, -20), new Vector(dx + 20, this.pos)));
            }
            varPos.put(v.getIdentifier(), dx);
            dx += 60;
        }
        for (FragmentVariable f : this.fragmentVariables) {
            Vector p = f.getCircuitPos();
            int in = (Integer)varPos.get(f.getVariable().getIdentifier());
            if (f.isInvert()) {
                in += 20;
            }
            circuit.add(new Wire(p, new Vector(in, p.y)));
        }
    }

    private boolean isNotNeeded(String identifier) {
        for (FragmentVariable fv : this.fragmentVariables) {
            if (!fv.isInvert() || !fv.getVariable().getIdentifier().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    private void addFragmentToCircuit(Fragment fr, Circuit circuit) {
        fr.setPos(new Vector(0, 0));
        Box b = fr.doLayout();
        if (fr.traverse(new FindLUTVisitor()).containsLUT()) {
            this.pos += 40;
        }
        fr.addToCircuit(new Vector(0, this.pos), circuit);
        this.pos += b.getHeight() + 40;
    }

    public Circuit createCircuit() {
        String stateVariableName;
        if (this.resolveLocalVars) {
            this.resolveLocalVars();
        }
        int maxWidth = 0;
        for (Fragment f : this.fragments) {
            Box b = f.doLayout();
            if (maxWidth >= b.getWidth()) continue;
            maxWidth = b.getWidth();
        }
        if (!this.sequentialVars.isEmpty()) {
            maxWidth += 40;
        }
        for (Fragment f : this.fragments) {
            if (!(f instanceof FragmentExpression)) continue;
            ((FragmentExpression)f).setWidth(maxWidth);
        }
        Circuit circuit = new Circuit();
        int outSplitterY = 0;
        if (this.mai != null) {
            outSplitterY = this.checkForOutputBus(maxWidth + 300, circuit);
        }
        for (Fragment f : this.fragments) {
            this.addFragmentToCircuit(f, circuit);
        }
        Collection<Variable> variables = this.variableVisitor.getVariables();
        if (this.desiredVarOrdering != null) {
            variables = CircuitBuilder.order(variables, this.desiredVarOrdering);
        }
        if (!this.sequentialVars.isEmpty()) {
            variables = CircuitBuilder.order(variables, this.sequentialVars);
        }
        if (this.mai != null) {
            this.checkForInputBus(variables, -100 - variables.size() * 20 * 3, circuit);
        }
        this.createInputBus(variables, circuit);
        if (!this.flipflops.isEmpty()) {
            this.addClockToFlipFlops(circuit);
        }
        if (this.combinatorialOutputs.isEmpty()) {
            outSplitterY = this.addNetConnections(circuit, maxWidth + 340, outSplitterY);
        }
        if (this.mai != null && (stateVariableName = this.mai.getStateSignalName()) != null) {
            outSplitterY = this.createStateVar(maxWidth + 300, outSplitterY, circuit, stateVariableName, this.mai.getStateSignalBitNames());
        }
        return circuit;
    }

    private void resolveLocalVars() {
        for (String lv : this.localVarsUsed) {
            this.varsToNet.add(lv);
            FragmentVisualElement frag = this.combinatorialOutputs.get(lv);
            frag.traverse(new ReplaceOutputByTunnel(lv, this.shapeFactory));
        }
    }

    private void checkForInputBus(Collection<Variable> variables, int splitterXPos, Circuit circuit) {
        StringBuilder pinString = new StringBuilder();
        int y = 0;
        for (ModelAnalyserInfo.Bus b : this.mai.getInputBusList()) {
            pinString.setLength(0);
            int found = 0;
            ArrayList<String> inputs = b.getSignalNames();
            for (String n : inputs) {
                if (!variables.contains(new Variable(n))) continue;
                ++found;
                String p = this.mai.getPins().get(n);
                if (p == null) continue;
                if (pinString.length() != 0) {
                    pinString.append(",");
                }
                pinString.append(p);
            }
            if (found != inputs.size()) continue;
            this.varsToNet.addAll(inputs);
            circuit.add(new VisualElement(Splitter.DESCRIPTION.getName()).setAttribute(Keys.INPUT_SPLIT, "" + inputs.size()).setAttribute(Keys.OUTPUT_SPLIT, "1*" + inputs.size()).setPos(new Vector(splitterXPos, y)).setShapeFactory(this.shapeFactory));
            circuit.add(new VisualElement(In.DESCRIPTION.getName()).setAttribute(Keys.LABEL, b.getBusName()).setAttribute(Keys.BITS, inputs.size()).setAttribute(Keys.PINNUMBER, pinString.toString()).setPos(new Vector(splitterXPos - 40, y)).setShapeFactory(this.shapeFactory));
            circuit.add(new Wire(new Vector(splitterXPos - 40, y), new Vector(splitterXPos, y)));
            int i = 0;
            while (i < inputs.size()) {
                circuit.add(new VisualElement(Tunnel.DESCRIPTION.getName()).setAttribute(Keys.NETNAME, inputs.get(i)).setPos(new Vector(splitterXPos + 40, y + i * 20)).setShapeFactory(this.shapeFactory));
                circuit.add(new Wire(new Vector(splitterXPos + 20, y + i * 20), new Vector(splitterXPos + 40, y + i * 20)));
                ++i;
            }
            y += (inputs.size() + 2) * 20;
        }
    }

    private int checkForOutputBus(int splitterXPos, Circuit circuit) {
        StringBuilder pinString = new StringBuilder();
        int y = 0;
        for (ModelAnalyserInfo.Bus b : this.mai.getOutputBusList()) {
            pinString.setLength(0);
            int found = 0;
            ArrayList<String> outputs = b.getSignalNames();
            for (String n : outputs) {
                if (!this.combinatorialOutputs.containsKey(n)) continue;
                ++found;
                String p = this.mai.getPins().get(n);
                if (p == null) continue;
                if (pinString.length() != 0) {
                    pinString.append(",");
                }
                pinString.append(p);
            }
            if (found != outputs.size()) continue;
            circuit.add(new VisualElement(Splitter.DESCRIPTION.getName()).setAttribute(Keys.OUTPUT_SPLIT, "" + outputs.size()).setAttribute(Keys.INPUT_SPLIT, "1*" + outputs.size()).setPos(new Vector(splitterXPos, y)).setShapeFactory(this.shapeFactory));
            circuit.add(new VisualElement(Out.DESCRIPTION.getName()).setAttribute(Keys.LABEL, b.getBusName()).setAttribute(Keys.BITS, outputs.size()).setAttribute(Keys.PINNUMBER, pinString.toString()).setPos(new Vector(splitterXPos + 60, y)).setShapeFactory(this.shapeFactory));
            circuit.add(new Wire(new Vector(splitterXPos + 60, y), new Vector(splitterXPos + 20, y)));
            int i = 0;
            while (i < outputs.size()) {
                circuit.add(new VisualElement(Tunnel.DESCRIPTION.getName()).setAttribute(Keys.NETNAME, outputs.get(i)).setRotation(2).setPos(new Vector(splitterXPos - 20, y + i * 20)).setShapeFactory(this.shapeFactory));
                circuit.add(new Wire(new Vector(splitterXPos - 20, y + i * 20), new Vector(splitterXPos, y + i * 20)));
                FragmentVisualElement frag = this.combinatorialOutputs.get(outputs.get(i));
                frag.setVisualElement(new VisualElement(Tunnel.DESCRIPTION.getName()).setShapeFactory(this.shapeFactory).setAttribute(Keys.NETNAME, outputs.get(i)));
                ++i;
            }
            y += (outputs.size() + 2) * 20;
        }
        return y;
    }

    private int createStateVar(int splitterXPos, int y, Circuit circuit, String name, ArrayList<String> bitNames) {
        circuit.add(new VisualElement(Splitter.DESCRIPTION.getName()).setAttribute(Keys.OUTPUT_SPLIT, "" + bitNames.size()).setAttribute(Keys.INPUT_SPLIT, "1*" + bitNames.size()).setPos(new Vector(splitterXPos, y)).setShapeFactory(this.shapeFactory));
        circuit.add(new VisualElement(Probe.DESCRIPTION.getName()).setAttribute(Keys.LABEL, name).setAttribute(Keys.BITS, bitNames.size()).setPos(new Vector(splitterXPos + 60, y)).setShapeFactory(this.shapeFactory));
        circuit.add(new Wire(new Vector(splitterXPos + 60, y), new Vector(splitterXPos + 20, y)));
        int i = 0;
        while (i < bitNames.size()) {
            circuit.add(new VisualElement(Tunnel.DESCRIPTION.getName()).setAttribute(Keys.NETNAME, bitNames.get(i)).setRotation(2).setPos(new Vector(splitterXPos - 20, y + i * 20)).setShapeFactory(this.shapeFactory));
            circuit.add(new Wire(new Vector(splitterXPos - 20, y + i * 20), new Vector(splitterXPos, y + i * 20)));
            ++i;
        }
        return y += (bitNames.size() + 2) * 20;
    }

    private static <T> ArrayList<T> order(Collection<T> variables, ArrayList<T> lastItems) {
        ArrayList<T> vars = new ArrayList<T>(variables);
        for (T seq : lastItems) {
            if (!vars.contains(seq)) continue;
            vars.remove(seq);
            vars.add(seq);
        }
        return vars;
    }

    private void addClockToFlipFlops(Circuit circuit) {
        int x = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (FragmentVisualElement ff : this.flipflops) {
            Vector p = ff.getVisualElement().getPos();
            if (p.x < x) {
                x = p.x;
            }
            if (p.y < yMin) {
                yMin = p.y;
            }
            if (p.y <= yMax) continue;
            yMax = p.y;
        }
        x -= 20;
        if (this.useJKff) {
            x -= 20;
        }
        int yPos = yMin - 60;
        if (this.useJKff) {
            yPos = -20;
        }
        circuit.add(new Wire(new Vector(x, yPos), new Vector(x, yMax + 20)));
        for (FragmentVisualElement ff : this.flipflops) {
            Vector p = ff.getVisualElement().getPos();
            circuit.add(new Wire(new Vector(x, p.y + 20), new Vector(p.x, p.y + 20)));
        }
        VisualElement clock = new VisualElement(Clock.DESCRIPTION.getName()).setShapeFactory(this.shapeFactory).setPos(new Vector(x, yPos));
        clock.getElementAttributes().set(Keys.LABEL, "C").set(Keys.ROTATE, new Rotation(3)).set(Keys.FREQUENCY, 2).set(Keys.RUN_AT_REAL_TIME, true);
        circuit.add(clock);
    }

    private int addNetConnections(Circuit circuit, int xPos, int y) {
        for (Variable name : this.sequentialVars) {
            String oName = name.getIdentifier();
            if (oName.endsWith("n") && ((oName = oName.substring(0, oName.length() - 1)).endsWith("_") || oName.endsWith("^"))) {
                oName = oName.substring(0, oName.length() - 1);
            }
            if (this.combinatorialOutputs.containsKey(oName)) continue;
            VisualElement t = new VisualElement(Tunnel.DESCRIPTION.getName()).setShapeFactory(this.shapeFactory);
            t.getElementAttributes().set(Keys.NETNAME, name.getIdentifier());
            t.setPos(new Vector(xPos, y));
            t.setRotation(2);
            circuit.add(t);
            VisualElement o = new VisualElement(Out.DESCRIPTION.getName()).setShapeFactory(this.shapeFactory);
            o.getElementAttributes().set(Keys.LABEL, oName);
            o.setPos(new Vector(xPos + 20, y));
            this.checkPinNumber(o);
            circuit.add(o);
            circuit.add(new Wire(new Vector(xPos, y), new Vector(xPos + 20, y)));
            y += 40;
        }
        return y;
    }

    private void checkPinNumber(VisualElement pin) {
        if (this.mai != null) {
            String name = pin.getElementAttributes().getLabel();
            String num = this.mai.getPins().get(name);
            if (num != null && num.length() > 0) {
                pin.getElementAttributes().set(Keys.PINNUMBER, num);
            }
        }
    }

    public CircuitBuilder setModelAnalyzerInfo(ModelAnalyserInfo modelAnalyserInfo) {
        this.mai = modelAnalyserInfo;
        return this;
    }

    private static final class FindLUTVisitor
    implements FragmentVisitor {
        private boolean hasLUT = false;

        private FindLUTVisitor() {
        }

        @Override
        public void visit(Fragment fr) {
            if (fr instanceof FragmentVisualElement && ((FragmentVisualElement)fr).getVisualElement().equalsDescription(LookUpTable.DESCRIPTION)) {
                this.hasLUT = true;
            }
        }

        private boolean containsLUT() {
            return this.hasLUT;
        }
    }

    private static final class ReplaceOutputByTunnel
    implements FragmentVisitor {
        private final String outName;
        private final ShapeFactory shapeFactory;

        private ReplaceOutputByTunnel(String outName, ShapeFactory shapeFactory) {
            this.outName = outName;
            this.shapeFactory = shapeFactory;
        }

        @Override
        public void visit(Fragment fr) {
            FragmentVisualElement fve;
            VisualElement ve;
            if (fr instanceof FragmentVisualElement && (ve = (fve = (FragmentVisualElement)fr).getVisualElement()).equalsDescription(Out.DESCRIPTION) && ve.getElementAttributes().getLabel().equals(this.outName)) {
                fve.setVisualElement(new VisualElement(Tunnel.DESCRIPTION.getName()).setAttribute(Keys.NETNAME, this.outName).setShapeFactory(this.shapeFactory));
            }
        }
    }
}

