/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.circuit;

import de.neemann.digital.builder.circuit.Box;
import de.neemann.digital.builder.circuit.Fragment;
import de.neemann.digital.builder.circuit.FragmentVariable;
import de.neemann.digital.builder.circuit.FragmentVisitor;
import de.neemann.digital.builder.circuit.FragmentVisualElement;
import de.neemann.digital.core.io.Const;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FragmentExpression
implements Fragment {
    private final ArrayList<FragmentHolder> fragments;
    private final Fragment merger;
    private Vector pos;
    private boolean normalLayout;
    private int alignedWidth;

    private static ArrayList<Fragment> createList(Fragment fragment) {
        ArrayList<Fragment> f = new ArrayList<Fragment>();
        f.add(fragment);
        return f;
    }

    public FragmentExpression(Fragment fragment, Fragment merger) {
        this(FragmentExpression.createList(fragment), merger);
    }

    public FragmentExpression(List<Fragment> frags, Fragment merger) {
        this.merger = merger;
        this.fragments = new ArrayList();
        for (Fragment fr : frags) {
            this.fragments.add(new FragmentHolder(fr));
        }
    }

    private Box doLayoutNormal() {
        int y;
        ArrayList<ConstExpression> constExpr = new ArrayList<ConstExpression>();
        int height = 0;
        int width = 0;
        for (FragmentHolder fr : this.fragments) {
            fr.fragment.setPos(new Vector(0, height));
            if (this.isConst(fr.fragment)) {
                constExpr.add(new ConstExpression(fr.fragment, height));
            }
            fr.box = fr.fragment.doLayout();
            height += fr.box.getHeight();
            int w = fr.box.getWidth();
            if (w > width) {
                width = w;
            }
            height += 40;
        }
        height -= 40;
        Box mergerBox = this.merger.doLayout();
        width += (this.fragments.size() / 2 + 1) * 20;
        if (this.alignedWidth > 0) {
            width = this.alignedWidth - mergerBox.getWidth();
        }
        for (ConstExpression ce : constExpr) {
            ce.setXPos(width);
        }
        int centerIndex = this.fragments.size() / 2;
        if ((this.fragments.size() & 1) == 0) {
            int y1 = ((FragmentHolder)this.fragments.get((int)(centerIndex - 1))).fragment.getOutputs().get((int)0).y;
            int y2 = ((FragmentHolder)this.fragments.get((int)centerIndex)).fragment.getOutputs().get((int)0).y;
            y = this.raster((y1 + y2) / 2) - centerIndex * 20;
        } else {
            y = ((FragmentHolder)this.fragments.get((int)centerIndex)).fragment.getOutputs().get((int)0).y - centerIndex * 20;
        }
        this.merger.setPos(new Vector(width, y));
        return new Box(width += mergerBox.getWidth(), Math.max(height, y + mergerBox.getHeight()));
    }

    private boolean isConst(Fragment fragment) {
        return fragment instanceof FragmentVisualElement && ((FragmentVisualElement)fragment).getVisualElement().equalsDescription(Const.DESCRIPTION);
    }

    private Box doLayoutOnlyVariables() {
        Box mergerBox;
        int xPos = 20;
        if (this.alignedWidth > 0) {
            mergerBox = this.merger.doLayout();
            xPos = this.alignedWidth - mergerBox.getWidth();
        }
        mergerBox = this.merger.doLayout();
        this.merger.setPos(new Vector(xPos, 0));
        Iterator<Vector> in = this.merger.getInputs().iterator();
        for (FragmentHolder fr : this.fragments) {
            fr.fragment.setPos(new Vector(0, in.next().y));
            fr.box = fr.fragment.doLayout();
        }
        return new Box(mergerBox.getWidth() + 20, mergerBox.getHeight());
    }

    @Override
    public Box doLayout() {
        for (FragmentHolder fr : this.fragments) {
            if (fr.fragment instanceof FragmentVariable) continue;
            this.normalLayout = true;
            return this.doLayoutNormal();
        }
        this.normalLayout = false;
        return this.doLayoutOnlyVariables();
    }

    private int raster(int k) {
        return (int)Math.round((double)k / 20.0) * 20;
    }

    @Override
    public void setPos(Vector pos) {
        this.pos = pos;
    }

    @Override
    public void addToCircuit(Vector offset, Circuit circuit) {
        Vector p = this.pos.add(offset);
        this.merger.addToCircuit(p, circuit);
        int i = 0;
        while (i < this.fragments.size()) {
            FragmentHolder fr = this.fragments.get(i);
            fr.fragment.addToCircuit(p, circuit);
            Vector pin = fr.fragment.getOutputs().get(0);
            Vector start = pin.add(p);
            Vector end = this.merger.getInputs().get(i).add(p);
            int back = 0;
            if (this.normalLayout) {
                back = FragmentExpression.calcBackOffset(this.fragments.size(), i);
            }
            if (back > 0) {
                Vector inter2 = end.add(-back * 20, 0);
                Vector inter1 = new Vector(inter2.x, start.y);
                circuit.add(new Wire(start, inter1));
                circuit.add(new Wire(inter1, inter2));
                circuit.add(new Wire(inter2, end));
            } else {
                circuit.add(new Wire(start, end));
            }
            ++i;
        }
    }

    static int calcBackOffset(int size, int i) {
        if ((size & 1) != 0 && i == (size - 1) / 2) {
            return 0;
        }
        if (i >= size / 2) {
            return size - i;
        }
        return i + 1;
    }

    @Override
    public List<Vector> getInputs() {
        ArrayList<Vector> pins = new ArrayList<Vector>();
        for (FragmentHolder fr : this.fragments) {
            pins.addAll(Vector.add(fr.fragment.getInputs(), this.pos));
        }
        return pins;
    }

    @Override
    public List<Vector> getOutputs() {
        return Vector.add(this.merger.getOutputs(), this.pos);
    }

    public void setWidth(int width) {
        this.alignedWidth = width;
    }

    @Override
    public <V extends FragmentVisitor> V traverse(V v) {
        v.visit(this);
        for (FragmentHolder f : this.fragments) {
            f.fragment.traverse(v);
        }
        this.merger.traverse(v);
        return v;
    }

    private static final class ConstExpression {
        private final Fragment fragment;
        private final int height;

        ConstExpression(Fragment fragment, int height) {
            this.fragment = fragment;
            this.height = height;
        }

        void setXPos(int xPos) {
            this.fragment.setPos(new Vector(xPos - 20, this.height));
        }
    }

    private static final class FragmentHolder {
        private final Fragment fragment;
        private Box box;

        FragmentHolder(Fragment fragment) {
            this.fragment = fragment;
        }
    }
}

