/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.tt2;

import de.neemann.digital.builder.ATF150x.ATFDialog;
import de.neemann.digital.builder.ExpressionToFileExporter;
import de.neemann.digital.builder.tt2.OSExecute;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.Screen;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class StartATF150xFitter
implements ExpressionToFileExporter.PostProcess {
    private final File fitterExe;
    private final ATFDialog atfDialog;

    private static File getFitterExe(String fitterName) {
        File fitter = Settings.getInstance().get(Keys.SETTINGS_ATF1502_FITTER);
        return new File(fitter, fitterName);
    }

    public StartATF150xFitter(ATFDialog atfDialog, int deviceNumber) {
        this(atfDialog, StartATF150xFitter.getFitterExe("fit" + deviceNumber + ".exe"));
    }

    private StartATF150xFitter(ATFDialog atfDialog, File fitterExe) {
        this.atfDialog = atfDialog;
        this.fitterExe = fitterExe;
    }

    @Override
    public File execute(File file) throws IOException {
        String tt2Name = file.getName();
        if (tt2Name.indexOf(32) >= 0) {
            throw new IOException(Lang.get("err_whiteSpaceNotAllowedInTT2Name", new Object[0]));
        }
        ArrayList<String> args = new ArrayList<String>();
        if (Screen.isLinux()) {
            args.add("wine");
        }
        args.add(this.fitterExe.getPath());
        args.add(tt2Name);
        try {
            String message = new OSExecute(args).setEnvVar("FITTERDIR", this.fitterExe.getParentFile().getPath()).setWorkingDir(file.getParentFile()).startAndWait();
            SwingUtilities.invokeLater(() -> this.atfDialog.setFitterResult(message));
            return SaveAsHelper.checkSuffix(file, "jed");
        }
        catch (IOException e) {
            throw new IOException(Lang.get("err_errorRunningFitter", new Object[0]), e);
        }
    }

    @Override
    public String getName() {
        return Lang.get("msg_startExternalFitter", new Object[0]);
    }
}

