/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import javax.swing.table.TableModel;

public class CSVWriter {
    private final TableModel tableModel;
    private boolean newLine = true;

    public CSVWriter(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public void writeTo(BufferedWriter w) throws IOException {
        int c = 0;
        while (c < this.tableModel.getColumnCount()) {
            this.writeCell(w, this.tableModel.getColumnName(c));
            ++c;
        }
        this.newLine(w);
        int r = 0;
        while (r < this.tableModel.getRowCount()) {
            int c2 = 0;
            while (c2 < this.tableModel.getColumnCount()) {
                this.writeCell(w, this.tableModel.getValueAt(r, c2));
                ++c2;
            }
            this.newLine(w);
            ++r;
        }
        w.close();
    }

    private void newLine(BufferedWriter w) throws IOException {
        w.newLine();
        this.newLine = true;
    }

    private void writeCell(BufferedWriter w, Object value) throws IOException {
        if (!this.newLine) {
            w.write(44);
        }
        if (value != null) {
            boolean quotes;
            String v = value.toString();
            boolean bl = quotes = v.contains(",") || v.contains(";") || v.contains("\t") || v.contains("\n");
            if (quotes) {
                w.write(34);
            }
            w.write(v);
            if (quotes) {
                w.write(34);
            }
        }
        this.newLine = false;
    }
}

