/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli;

import de.neemann.digital.cli.CircuitLoader;
import de.neemann.digital.cli.cli.Argument;
import de.neemann.digital.cli.cli.ArgumentKey;
import de.neemann.digital.cli.cli.BasicCommand;
import de.neemann.digital.cli.cli.CLIException;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.graphics.Export;
import de.neemann.digital.draw.graphics.GraphicSVG;
import de.neemann.digital.draw.graphics.SVGSettings;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;

public class SVGExport
extends BasicCommand {
    private final ElementAttributes attr;
    private final Argument<String> digFile = this.addArgument(new Argument<String>("dig", "", false));
    private final Argument<String> svgFile = this.addArgument(new Argument<String>("svg", "", true));
    private final Argument<Boolean> ieeeShapes = this.addArgument(new Argument<Boolean>("ieee", false, true));

    public SVGExport() {
        super("svg");
        this.attr = new ElementAttributes();
        for (Key k : SVGSettings.createKeyList()) {
            this.addArgument(new ArgumentKey(k, this.attr, 4));
        }
    }

    @Override
    protected void execute() throws CLIException {
        try {
            Circuit circuit = new CircuitLoader(this.digFile.get(), (boolean)this.ieeeShapes.get()).getCircuit();
            String outName = this.svgFile.isSet() ? this.svgFile.get() : String.valueOf(this.digFile.get()) + ".svg";
            new Export(circuit, o -> new GraphicSVG(o, this.attr)).export(new File(outName));
        }
        catch (IOException e) {
            throw new CLIException(Lang.get("cli_errorCreatingSVG", new Object[0]), e);
        }
    }
}

