/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli.cli;

import de.neemann.digital.cli.cli.ArgumentBase;
import de.neemann.digital.cli.cli.CLIException;
import de.neemann.digital.cli.cli.NamedCommand;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public abstract class BasicCommand
extends NamedCommand {
    private final ArrayList<ArgumentBase<?>> arguments = new ArrayList();

    public BasicCommand(String name) {
        super(name);
    }

    public <T, A extends ArgumentBase<T>> A addArgument(A argument) {
        this.arguments.add(argument);
        return argument;
    }

    @Override
    public void printDescription(PrintStream out, String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        for (ArgumentBase<?> a : this.arguments) {
            sb.append(" ");
            sb.append(a);
        }
        sb.append(":");
        out.print(prefix);
        this.printString(out, String.valueOf(prefix) + "      ", sb.toString());
        prefix = String.valueOf(prefix) + "  ";
        out.print(String.valueOf(prefix) + "  ");
        this.printString(out, String.valueOf(prefix) + "  ", Lang.get("cli_help_" + this.getName(), new Object[0]));
        out.print(prefix);
        out.println(Lang.get("cli_options", new Object[0]));
        for (ArgumentBase<?> a : this.arguments) {
            out.println(String.valueOf(prefix) + "  " + a.toStringDef());
            out.print(String.valueOf(prefix) + "    ");
            this.printString(out, String.valueOf(prefix) + "    ", a.getDescription(this.getName()));
        }
    }

    @Override
    public void printXMLDescription(Writer w) throws IOException {
        w.write("<indent>\n");
        w.append(this.getName());
        for (ArgumentBase<?> a : this.arguments) {
            w.append(" ");
            w.append(a.toString());
        }
        w.append(":");
        w.write("<indent>\n");
        w.write(Lang.get("cli_help_" + this.getName(), new Object[0]));
        w.write("</indent>\n");
        w.write("<indent>\n");
        w.write(Lang.get("cli_options", new Object[0]));
        for (ArgumentBase<?> a : this.arguments) {
            w.write("<indent>\n");
            w.write(a.toStringDef());
            w.write("<indent>\n");
            w.write(a.getDescription(this.getName()));
            w.write("</indent>\n");
            w.write("</indent>\n");
        }
        w.write("</indent>\n");
        w.write("</indent>\n");
    }

    void printString(PrintStream out, String prefix, String message) {
        boolean lastWasSpace = false;
        int col = prefix.length();
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            if (c == '\n') {
                c = ' ';
            }
            if (c != ' ' || !lastWasSpace) {
                if (c == ' ') {
                    if (col > 70) {
                        out.print('\n');
                        out.print(prefix);
                        col = prefix.length();
                    } else {
                        out.print(c);
                        ++col;
                    }
                } else {
                    out.print(c);
                    ++col;
                }
            }
            lastWasSpace = c == ' ';
            ++i;
        }
        out.println();
    }

    private void set(String arg, Iterator<String> args) throws CLIException {
        for (ArgumentBase<?> a : this.arguments) {
            if (!arg.equals(a.getName())) continue;
            if (a.isBool()) {
                a.toggle();
            } else {
                if (!args.hasNext()) {
                    throw new CLIException(Lang.get("cli_notEnoughArgumentsGiven", new Object[0]), 100);
                }
                a.setString(args.next());
            }
            return;
        }
        throw new CLIException(Lang.get("cli_noArgument_N_available", arg), 104);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute(String[] args) throws CLIException {
        nonOptional = 0;
        it = Arrays.asList(args).iterator();
        while (it.hasNext()) {
            n = it.next();
            if (!n.startsWith("-")) ** GOTO lbl9
            this.set(n.substring(1), it);
            continue;
lbl-1000:
            // 1 sources

            {
                ++nonOptional;
lbl9:
                // 2 sources

                ** while (nonOptional < this.arguments.size() && this.arguments.get((int)nonOptional).isOptional())
            }
lbl10:
            // 1 sources

            if (nonOptional == this.arguments.size()) {
                throw new CLIException(Lang.get("cli_toMuchArguments", new Object[0]), 105);
            }
            this.arguments.get(nonOptional).setString(n);
            ++nonOptional;
        }
        for (ArgumentBase<?> a : this.arguments) {
            if (a.isOptional() || a.isSet()) continue;
            throw new CLIException(Lang.get("cli_nonOptionalArgumentMissing_N", new Object[]{a}), 105);
        }
        this.execute();
    }

    protected abstract void execute() throws CLIException;
}

