/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.analyse.AnalyseException;
import de.neemann.digital.core.GlobalValues;
import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserver;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.core.io.Button;
import de.neemann.digital.core.wiring.AsyncSeq;
import de.neemann.digital.core.wiring.Break;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.core.wiring.Reset;
import de.neemann.digital.gui.components.WindowPosManager;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Model
implements Iterable<Node>,
SyncAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(Model.class);
    private static final int COLLECTING_LOOP_COUNTER_OFFS = 100;
    private ArrayList<BreakDetector> brVal;
    private int oscillationDetectionCounter = 1000;
    private State state = State.BUILDING;
    private final ArrayList<Clock> clocks = new ArrayList();
    private final ArrayList<Break> breaks = new ArrayList();
    private final ArrayList<Reset> resets = new ArrayList();
    private final HashMap<Integer, Button> buttonsToMap = new HashMap();
    private final ArrayList<Signal> signals = new ArrayList();
    private final ArrayList<Signal> inputs;
    private final ArrayList<Signal> outputs = new ArrayList();
    private final ArrayList<Signal> testOutputs = new ArrayList();
    private final ArrayList<Node> nodes;
    private ArrayList<Node> nodesToUpdateAct;
    private ArrayList<Node> nodesToUpdateNext;
    private int version;
    private WindowPosManager windowPosManager;
    private HashSet<Node> oscillatingNodes;
    private Signal invalidSignal = null;
    private AsyncSeq asyncInfos;
    private boolean asyncMode = false;
    private boolean allowGlobalValues = false;
    private File rootPath;
    private final ArrayList<ModelStateObserver> observers;
    private ArrayList<ModelStateObserver> observersStep;
    private ArrayList<ModelStateObserver> observersMicroStep;

    public Model() {
        this.inputs = new ArrayList();
        this.nodes = new ArrayList();
        this.nodesToUpdateAct = new ArrayList();
        this.nodesToUpdateNext = new ArrayList();
        this.observers = new ArrayList();
    }

    public Model setOscillationDetectionCounter(int oscillationDetectionCounter) {
        this.oscillationDetectionCounter = oscillationDetectionCounter;
        return this;
    }

    public Model setAsyncMode() {
        this.asyncMode = true;
        return this;
    }

    public void setWindowPosManager(WindowPosManager windowPosManager) {
        this.windowPosManager = windowPosManager;
    }

    public WindowPosManager getWindowPosManager() {
        if (this.windowPosManager == null) {
            this.windowPosManager = new WindowPosManager(null);
        }
        return this.windowPosManager;
    }

    public boolean runningInMainFrame() {
        if (this.windowPosManager == null) {
            return false;
        }
        return this.windowPosManager.getMainFrame() != null;
    }

    public int getStepCounter() {
        return this.version;
    }

    public <T extends Node> T add(T node) {
        if (this.state != State.BUILDING) {
            throw new RuntimeException(Lang.get("err_isAlreadyInitialized", new Object[0]));
        }
        this.nodes.add(node);
        node.setModel(this);
        return node;
    }

    public void init() {
        this.init(true);
    }

    public void init(boolean noise) {
        this.nodesToUpdateNext.addAll(this.nodes);
        this.state = State.INITIALIZING;
        this.doStep(noise);
        if (this.state != State.CLOSED) {
            if (!this.resets.isEmpty()) {
                for (Reset reset : this.resets) {
                    reset.clearReset();
                }
                if (!this.asyncMode) {
                    this.doStep(false);
                } else {
                    this.doMicroStep(false);
                }
            }
            LOGGER.debug("stabilizing took " + this.version + " micro steps");
            this.state = State.RUNNING;
            this.fireEvent(ModelEvent.STARTED);
        }
    }

    public synchronized void close() {
        if (this.state != State.CLOSED) {
            this.state = State.CLOSED;
            int obs = this.observers.size();
            if (this.observersStep != null) {
                obs += this.observersStep.size();
            }
            if (this.observersMicroStep != null) {
                obs += this.observersMicroStep.size();
            }
            LOGGER.debug("Observers " + obs);
            for (ModelStateObserver ob : this.observers) {
                LOGGER.debug("Observer Slow : " + ob.getClass().getSimpleName());
            }
            if (this.observersStep != null) {
                for (ModelStateObserver ob : this.observersStep) {
                    LOGGER.debug("Observer Step : " + ob.getClass().getSimpleName());
                }
            }
            if (this.observersMicroStep != null) {
                for (ModelStateObserver ob : this.observersMicroStep) {
                    LOGGER.debug("Observer Micro: " + ob.getClass().getSimpleName());
                }
            }
            this.fireEvent(ModelEvent.CLOSED);
            this.fireEvent(ModelEvent.POSTCLOSED);
        }
    }

    public void errorOccurred(Exception cause) {
        if (this.state != State.CLOSED) {
            this.fireEvent(new ModelEvent(cause));
        }
        this.close();
    }

    public boolean isRunning() {
        return this.state != State.CLOSED;
    }

    final void addToUpdateList(Node node) {
        this.nodesToUpdateNext.add(node);
    }

    public void doStep() {
        this.doStep(false);
    }

    public void doStep(boolean noise) {
        this.stepWithCondition(noise, this::needsUpdate);
    }

    private synchronized void stepWithCondition(boolean noise, StepCondition cond) {
        try {
            if (cond.doNextMicroStep()) {
                int counter = 0;
                while (cond.doNextMicroStep() && this.state != State.CLOSED) {
                    if (counter++ > this.oscillationDetectionCounter) {
                        if (this.oscillatingNodes == null) {
                            this.oscillatingNodes = new HashSet();
                        }
                        if (counter > this.oscillationDetectionCounter + 100) {
                            NodeException seemsToOscillate = new NodeException(Lang.get("err_seemsToOscillate", new Object[0]), new ObservableValue[0]).addNodes(this.oscillatingNodes);
                            this.oscillatingNodes = null;
                            throw seemsToOscillate;
                        }
                        this.oscillatingNodes.addAll(this.nodesToUpdateNext);
                    }
                    this.doMicroStep(noise);
                }
            } else {
                this.fireEvent(ModelEvent.CHECKBURN);
            }
        }
        catch (Exception e) {
            this.errorOccurred(e);
        }
    }

    public synchronized void doMicroStep(boolean noise) {
        ++this.version;
        ArrayList<Node> nl = this.nodesToUpdateNext;
        this.nodesToUpdateNext = this.nodesToUpdateAct;
        this.nodesToUpdateAct = nl;
        this.nodesToUpdateNext.clear();
        try {
            if (noise) {
                Collections.shuffle(this.nodesToUpdateAct);
                for (Node n : this.nodesToUpdateAct) {
                    n.readInputs();
                    n.writeOutputs();
                }
            } else {
                for (Node n : this.nodesToUpdateAct) {
                    n.readInputs();
                }
                for (Node n : this.nodesToUpdateAct) {
                    n.writeOutputs();
                }
            }
            if (this.observersMicroStep != null) {
                this.fireEvent(ModelEvent.MICROSTEP);
            }
            if (this.nodesToUpdateNext.isEmpty()) {
                this.fireEvent(ModelEvent.STEP);
            }
        }
        catch (Exception e) {
            this.errorOccurred(e);
        }
    }

    public BreakInfo runToBreak() {
        return this.runToBreak(-1);
    }

    public BreakInfo runToBreak(int timeout) {
        if (this.brVal == null) {
            this.brVal = new ArrayList();
            for (Break b : this.breaks) {
                this.brVal.add(new BreakDetector(b));
            }
            this.fireEvent(ModelEvent.RUN_TO_BREAK);
        }
        ObservableValue clkVal = this.clocks.get(0).getClockOutput();
        try {
            while (this.state != State.CLOSED) {
                clkVal.setBool(!clkVal.getBool());
                this.doStep();
                for (BreakDetector bd : this.brVal) {
                    if (!bd.detected()) continue;
                    this.fireEvent(ModelEvent.BREAK);
                    this.brVal = null;
                    return bd.createInfo();
                }
                if (timeout <= 0 || --timeout != 0) continue;
                this.fireEvent(ModelEvent.RUN_TO_BREAK_TIMEOUT);
                return new BreakInfo(timeout);
            }
        }
        catch (Exception e) {
            this.errorOccurred(e);
        }
        return null;
    }

    public BreakInfo runToBreakMicro() {
        return this.runToBreakMicro(-1);
    }

    public BreakInfo runToBreakMicro(int timeout) {
        if (this.brVal == null) {
            this.brVal = new ArrayList();
            for (Break b : this.breaks) {
                this.brVal.add(new BreakDetector(b));
            }
            if (!this.brVal.isEmpty()) {
                this.fireEvent(ModelEvent.RUN_TO_BREAK);
            }
        }
        if (this.brVal.isEmpty()) {
            this.doStep();
        } else {
            ObservableValue clkVal = null;
            if (this.clocks.size() == 1) {
                clkVal = this.clocks.get(0).getClockOutput();
            }
            while (this.state != State.CLOSED) {
                if (!this.needsUpdate()) {
                    if (clkVal == null) break;
                    clkVal.setBool(!clkVal.getBool());
                }
                BreakDetector[] wasBreak = new BreakDetector[1];
                this.stepWithCondition(false, () -> {
                    for (BreakDetector bd : this.brVal) {
                        if (!bd.detected()) continue;
                        this.fireEvent(ModelEvent.BREAK);
                        breakDetectorArray[0] = bd;
                    }
                    return this.needsUpdate() && wasBreak[0] == null;
                });
                if (wasBreak[0] != null) {
                    this.brVal = null;
                    return wasBreak[0].createInfo();
                }
                if (timeout <= 0 || --timeout != 0) continue;
                this.fireEvent(ModelEvent.RUN_TO_BREAK_TIMEOUT);
                return new BreakInfo(timeout);
            }
        }
        return null;
    }

    public boolean isRunToBreakAllowed() {
        return this.clocks.size() == 1 && !this.breaks.isEmpty();
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public boolean needsUpdate() {
        return !this.nodesToUpdateNext.isEmpty();
    }

    public Collection<Node> nodesToUpdate() {
        return this.nodesToUpdateNext;
    }

    public synchronized void addObserver(ModelStateObserver observer, ModelEventType event, ModelEventType ... events) {
        this.addObserverForEvent(observer, event);
        ModelEventType[] modelEventTypeArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ModelEventType ev = modelEventTypeArray[n2];
            this.addObserverForEvent(observer, ev);
            ++n2;
        }
    }

    public synchronized void addObserver(ModelStateObserverTyped observer) {
        ModelEventType[] modelEventTypeArray = observer.getEvents();
        int n = modelEventTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelEventType ev = modelEventTypeArray[n2];
            this.addObserverForEvent(observer, ev);
            ++n2;
        }
    }

    private synchronized void addObserverForEvent(ModelStateObserver observer, ModelEventType event) {
        ArrayList<ModelStateObserver> obs = this.observers;
        if (event == ModelEventType.STEP || event == ModelEventType.CHECKBURN) {
            if (this.observersStep == null) {
                this.observersStep = new ArrayList();
            }
            obs = this.observersStep;
        } else if (event == ModelEventType.MICROSTEP) {
            if (this.observersMicroStep == null) {
                this.observersMicroStep = new ArrayList();
            }
            obs = this.observersMicroStep;
        }
        if (!obs.contains(observer)) {
            obs.add(observer);
        }
    }

    public synchronized void removeObserver(ModelStateObserver observer) {
        this.observers.remove(observer);
        if (this.observersStep != null) {
            this.observersStep.remove(observer);
        }
        if (this.observersMicroStep != null) {
            this.observersMicroStep.remove(observer);
        }
    }

    public synchronized <T extends ModelStateObserver> T getObserver(Class<T> observerClass) {
        for (ModelStateObserver mso : this.observers) {
            if (mso.getClass() != observerClass) continue;
            return (T)mso;
        }
        if (this.observersStep != null) {
            for (ModelStateObserver mso : this.observersStep) {
                if (mso.getClass() != observerClass) continue;
                return (T)mso;
            }
        }
        if (this.observersMicroStep != null) {
            for (ModelStateObserver mso : this.observersMicroStep) {
                if (mso.getClass() != observerClass) continue;
                return (T)mso;
            }
        }
        return null;
    }

    public synchronized <T extends ModelStateObserverTyped> T getOrCreateObserver(Class<T> observerClass, ObserverFactory<T> factory) {
        ModelStateObserverTyped o = (ModelStateObserverTyped)this.getObserver(observerClass);
        if (o == null) {
            o = factory.create();
            if (o == null) {
                throw new NullPointerException("no observer created!");
            }
            this.addObserver(o);
        }
        return (T)o;
    }

    private void fireEvent(ModelEvent event) {
        switch (event.getType()) {
            case MICROSTEP: {
                if (this.observersMicroStep == null) break;
                for (ModelStateObserver observer : this.observersMicroStep) {
                    observer.handleEvent(event);
                }
                break;
            }
            case STEP: 
            case CHECKBURN: {
                if (this.observersStep == null) break;
                for (ModelStateObserver observer : this.observersStep) {
                    observer.handleEvent(event);
                }
                break;
            }
            default: {
                for (ModelStateObserver observer : this.observers) {
                    observer.handleEvent(event);
                }
            }
        }
    }

    public void addClock(Clock clock) {
        this.clocks.add(clock);
    }

    public ArrayList<Clock> getClocks() {
        return this.clocks;
    }

    public void addBreak(Break aBreak) {
        if (aBreak.isEnabled()) {
            this.breaks.add(aBreak);
        }
    }

    public void addReset(Reset reset) {
        this.resets.add(reset);
    }

    public ArrayList<Reset> getResets() {
        return this.resets;
    }

    public void addSignal(Signal signal) {
        if (signal.isValid()) {
            if (this.signals.contains(signal)) {
                this.invalidSignal = signal;
            }
            this.signals.add(signal);
            if (signal.isTestOutput()) {
                this.testOutputs.add(signal);
            }
        }
    }

    public void addInput(Signal signal) {
        if (signal.isValid()) {
            if (this.signals.contains(signal)) {
                this.invalidSignal = signal;
            }
            this.signals.add(signal);
            this.inputs.add(signal);
        } else {
            this.invalidSignal = signal;
        }
    }

    public ArrayList<Signal> getInputs() {
        return this.inputs;
    }

    public void addOutput(Signal signal) {
        if (signal.isValid()) {
            if (this.signals.contains(signal)) {
                this.invalidSignal = signal;
            }
            this.signals.add(signal);
            this.outputs.add(signal);
            this.testOutputs.add(signal);
        } else {
            this.invalidSignal = signal;
        }
    }

    public void checkForInvalidSignals() throws AnalyseException {
        if (this.invalidSignal != null) {
            String name = this.invalidSignal.getName();
            if (name == null || name.trim().length() == 0) {
                throw new AnalyseException(Lang.get("err_thereIsAUnnamedIO", new Object[0]));
            }
            throw new AnalyseException(Lang.get("err_NameOfIOIsInvalidOrNotUnique_N", name));
        }
    }

    public ArrayList<Signal> getOutputs() {
        return this.outputs;
    }

    public ArrayList<Signal> getTestOutputs() {
        return this.testOutputs;
    }

    public ArrayList<Signal> getSignals() {
        return this.signals;
    }

    public ArrayList<Signal> getSignalsCopy() {
        ArrayList<Signal> n = new ArrayList<Signal>(this.signals.size());
        n.addAll(this.signals);
        return n;
    }

    public int size() {
        return this.nodes.size();
    }

    public <NODE extends Node> List<NODE> findNode(Class<NODE> nodeClass) {
        return this.findNode(nodeClass, n -> true);
    }

    public <NODE extends Node> List<NODE> findNode(Class<NODE> nodeClass, NodeFilter<NODE> filter) {
        ArrayList<Node> found = new ArrayList<Node>();
        for (Node n : this.nodes) {
            if (n.getClass() != nodeClass || !filter.accept(n)) continue;
            found.add(n);
        }
        return found;
    }

    public List<Node> findNode(NodeFilter<Node> filter) {
        ArrayList<Node> found = new ArrayList<Node>();
        for (Node n : this.nodes) {
            if (!filter.accept(n)) continue;
            found.add(n);
        }
        return found;
    }

    public void addButtonToMap(Button button, int keyCode) {
        this.buttonsToMap.put(keyCode, button);
    }

    public Button getButtonToMap(int keyCode) {
        return this.buttonsToMap.get(keyCode);
    }

    @Override
    public Iterator<Node> iterator() {
        return this.nodes.iterator();
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
    }

    public void replace(Node oldNode, Node newNode) throws NodeException {
        int i = this.nodes.indexOf(oldNode);
        if (i < 0) {
            throw new NodeException("node not found", oldNode, -1, null);
        }
        this.nodes.set(i, newNode);
    }

    public ObservableValue getInput(String name) {
        for (Signal i : this.inputs) {
            if (!i.getName().equals(name)) continue;
            return i.getValue();
        }
        return null;
    }

    public ObservableValue getOutput(String name) {
        for (Signal i : this.outputs) {
            if (!i.getName().equals(name)) continue;
            return i.getValue();
        }
        return null;
    }

    public Signal.Setter getSignalSetter(String name) {
        for (Signal i : this.signals) {
            if (!i.getName().equals(name)) continue;
            return i.getSetter();
        }
        return null;
    }

    public void registerGlobalValue(String name, ObservableValue value) {
        if (this.allowGlobalValues) {
            GlobalValues.getInstance().register(name, value, this);
        }
    }

    public Model setAllowGlobalValues(boolean allowGlobalValues) {
        this.allowGlobalValues = allowGlobalValues;
        return this;
    }

    public void setAsyncInfos(AsyncSeq asyncInfos) {
        this.asyncInfos = asyncInfos;
    }

    public AsyncSeq getAsyncInfos() {
        return this.asyncInfos;
    }

    public Model setRootPath(File rootPath) {
        this.rootPath = rootPath != null && rootPath.isFile() ? rootPath.getParentFile() : rootPath;
        return this;
    }

    public File getRootPath() {
        return this.rootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Runnable> A modify(A run) {
        Model model = this;
        synchronized (model) {
            run.run();
        }
        this.fireEvent(ModelEvent.MICROSTEP);
        this.doStep();
        return run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends Runnable> A modifyWithoutDoStep(A run) {
        Model model = this;
        synchronized (model) {
            run.run();
        }
        this.fireEvent(ModelEvent.MICROSTEP);
        return run;
    }

    public SyncAccess createSync(boolean microStep) {
        if (microStep) {
            return new SyncAccess(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public <A extends Runnable> A modify(A run) {
                    Model model = Model.this;
                    synchronized (model) {
                        run.run();
                    }
                    Model.this.fireEvent(ModelEvent.MICROSTEP);
                    return run;
                }

                @Override
                public <A extends Runnable> A read(A run) {
                    return Model.this.read(run);
                }
            };
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Runnable> A read(A run) {
        Model model = this;
        synchronized (model) {
            run.run();
        }
        return run;
    }

    private static final class BreakDetector {
        private final ObservableValue brVal;
        private final int count;
        private final String label;
        private boolean lastIn;
        private int c;

        private BreakDetector(Break breakComp) {
            this.label = breakComp.getLabel();
            this.count = breakComp.getCycles() * 2;
            this.brVal = breakComp.getBreakInput();
            this.lastIn = this.brVal.getBool();
            this.c = 0;
        }

        private boolean detected() throws NodeException {
            ++this.c;
            if (this.c >= this.count) {
                throw new NodeException(Lang.get("err_breakTimeOut", this.c, this.label), this.brVal);
            }
            boolean aktIn = this.brVal.getBool();
            if (!this.lastIn && aktIn) {
                this.lastIn = aktIn;
                return true;
            }
            this.lastIn = aktIn;
            return false;
        }

        private BreakInfo createInfo() {
            return new BreakInfo(this.c, this.label);
        }
    }

    public static final class BreakInfo {
        private final boolean timeout;
        private final int steps;
        private final String label;

        private BreakInfo(int steps) {
            this.steps = steps;
            this.label = null;
            this.timeout = true;
        }

        private BreakInfo(int steps, String label) {
            this.steps = steps;
            this.label = label;
            this.timeout = false;
        }

        public int getSteps() {
            return this.steps;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isTimeout() {
            return this.timeout;
        }
    }

    public static interface NodeFilter<NODE extends Node> {
        public boolean accept(NODE var1);
    }

    public static interface ObserverFactory<T extends ModelStateObserverTyped> {
        public T create();
    }

    private static enum State {
        BUILDING,
        INITIALIZING,
        RUNNING,
        CLOSED;

    }

    private static interface StepCondition {
        public boolean doNextMicroStep() throws NodeException;
    }
}

