/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.ModelEventType;
import java.util.Objects;

public class ModelEvent {
    public static final ModelEvent STARTED = new ModelEvent(ModelEventType.STARTED);
    public static final ModelEvent CLOSED = new ModelEvent(ModelEventType.CLOSED);
    public static final ModelEvent POSTCLOSED = new ModelEvent(ModelEventType.POSTCLOSED);
    public static final ModelEvent STEP = new ModelEvent(ModelEventType.STEP);
    public static final ModelEvent CHECKBURN = new ModelEvent(ModelEventType.CHECKBURN);
    public static final ModelEvent MICROSTEP = new ModelEvent(ModelEventType.MICROSTEP);
    public static final ModelEvent RUN_TO_BREAK = new ModelEvent(ModelEventType.RUN_TO_BREAK);
    public static final ModelEvent RUN_TO_BREAK_TIMEOUT = new ModelEvent(ModelEventType.RUN_TO_BREAK_TIMEOUT);
    public static final ModelEvent BREAK = new ModelEvent(ModelEventType.BREAK);
    private final ModelEventType type;
    private Exception cause;

    private ModelEvent(ModelEventType type) {
        this.type = type;
    }

    ModelEvent(Exception cause) {
        this(ModelEventType.ERROR_OCCURRED);
        this.cause = cause;
    }

    public ModelEventType getType() {
        return this.type;
    }

    public Exception getCause() {
        return this.cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelEvent that = (ModelEvent)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }
}

