/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.Observer;
import java.util.ArrayList;

public class Observable {
    private final ArrayList<Observer> observers = new ArrayList();

    public Observer addObserver(Observer observer) {
        if (observer != null && !this.observers.contains(observer)) {
            this.observers.add(observer);
        }
        return observer;
    }

    public int observerCount() {
        return this.observers.size();
    }

    public void removeObserver(Observer observer) {
        this.observers.remove(observer);
    }

    public void removeObserver(Class<? extends Observer> observerClass) {
        this.observers.removeIf(observer -> observer.getClass() == observerClass);
    }

    public void fireHasChanged() {
        for (Observer o : this.observers) {
            o.hasChanged();
        }
    }

    public boolean hasObserver(Observer observer) {
        return this.observers.contains(observer);
    }

    public ArrayList<Observer> getObservers() {
        return this.observers;
    }
}

