/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.element.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ObservableValues
extends ImmutableList<ObservableValue> {
    public static final ObservableValues EMPTY_LIST = new ObservableValues(new ObservableValue[0]);

    public static ObservableValues ovs(ObservableValue ... items) {
        return new ObservableValues(items);
    }

    public ObservableValues(ObservableValue ... items) {
        super(items);
    }

    public ObservableValues(Collection<ObservableValue> items) {
        super(items.toArray(new ObservableValue[items.size()]));
    }

    public ObservableValues(ObservableValues items, int from, int to) {
        super(items, from, to);
    }

    public ArrayList<String> getNames() {
        ArrayList<String> names = new ArrayList<String>(this.size());
        for (ObservableValue o : this) {
            names.add(o.getName());
        }
        return names;
    }

    public ObservableValue get(String name) {
        for (ObservableValue o : this) {
            if (!o.getName().equalsIgnoreCase(name)) continue;
            return o;
        }
        return null;
    }

    public static class Builder
    implements Iterable<ObservableValue> {
        private ArrayList<ObservableValue> values = new ArrayList();

        public Builder add(ObservableValue ... val) {
            this.values.addAll(Arrays.asList(val));
            return this;
        }

        public Builder add(Collection<? extends ObservableValue> val) {
            this.values.addAll(val);
            return this;
        }

        public Builder addAtTop(ObservableValue val) {
            this.values.add(0, val);
            return this;
        }

        public Builder reverse() {
            Collections.reverse(this.values);
            return this;
        }

        public ObservableValues build() {
            return new ObservableValues((Collection<ObservableValue>)this.values);
        }

        @Override
        public Iterator<ObservableValue> iterator() {
            return this.values.iterator();
        }
    }
}

