/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.arithmetic;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.arithmetic.BarrelShifterMode;
import de.neemann.digital.core.arithmetic.LeftRightFormat;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;

public class BarrelShifter
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(BarrelShifter.class, PinInfo.input("in"), PinInfo.input("shift")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.BITS).addAttribute(Keys.BARREL_SIGNED).addAttribute(Keys.DIRECTION).addAttribute(Keys.BARREL_SHIFTER_MODE);
    private final ObservableValue out;
    private final int bits;
    private final int shiftBits;
    private final BarrelShifterMode mode;
    private final boolean signed;
    private final LeftRightFormat direction;
    private ObservableValue in;
    private ObservableValue shift;
    private long value;

    public BarrelShifter(ElementAttributes attributes) {
        this.direction = attributes.get(Keys.DIRECTION);
        this.mode = attributes.get(Keys.BARREL_SHIFTER_MODE);
        this.bits = attributes.get(Keys.BITS);
        this.signed = attributes.get(Keys.BARREL_SIGNED);
        int sBits = Bits.binLn2(this.bits);
        if (this.signed) {
            ++sBits;
        }
        this.shiftBits = sBits;
        this.out = new ObservableValue("out", this.bits).setPinDescription(DESCRIPTION);
    }

    @Override
    public void readInputs() throws NodeException {
        long inVal = this.in.getValue();
        int shiftVal = this.signed ? (int)this.shift.getValueSigned() : (int)this.shift.getValue();
        if (this.direction == LeftRightFormat.right) {
            shiftVal = -shiftVal;
        }
        this.value = 0L;
        if (shiftVal < 0) {
            shiftVal = -shiftVal;
            if (this.mode == BarrelShifterMode.rotate) {
                this.value |= Bits.up(inVal, this.bits - (shiftVal %= this.bits));
            }
            this.value |= Bits.down(inVal, shiftVal);
            if (this.mode == BarrelShifterMode.arithmetic && Bits.isNegative(inVal, this.bits)) {
                long mask = Bits.mask(this.bits);
                mask = Bits.down(mask, shiftVal);
                this.value |= mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            if (this.mode == BarrelShifterMode.rotate) {
                this.value |= Bits.down(inVal, this.bits - (shiftVal %= this.bits));
            }
            this.value |= Bits.up(inVal, shiftVal);
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.out.setValue(this.value);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.in = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.bits, this, 0);
        this.shift = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(this.shiftBits, this, 1);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.out.asList();
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }
}

