/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.arithmetic;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;

public class BitCount
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(BitCount.class, PinInfo.input("in")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS);
    private final ObservableValue output;
    private final int inBits;
    private ObservableValue input;
    private long value;

    public BitCount(ElementAttributes attributes) {
        this.inBits = attributes.get(Keys.BITS);
        int outBits = Bits.binLn2(this.inBits);
        this.output = new ObservableValue("out", outBits).setPinDescription(DESCRIPTION);
    }

    @Override
    public void readInputs() throws NodeException {
        this.value = this.input.getValue();
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.output.setValue(Long.bitCount(this.value));
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.input = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.inBits, this, 0);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public int getDataBits() {
        return this.inBits;
    }
}

