/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.arithmetic;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.lang.Lang;

public class Mul
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Mul.class, PinInfo.input("a"), PinInfo.input("b")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.SIGNED).addAttribute(Keys.BITS).supportsHDL();
    private final ObservableValue mul;
    private final int bits;
    private final boolean signed;
    private ObservableValue a;
    private ObservableValue b;
    private long value;

    public Mul(ElementAttributes attributes) {
        this.signed = attributes.get(Keys.SIGNED);
        this.bits = attributes.get(Keys.BITS);
        int outBits = this.bits * 2;
        if (outBits > 64) {
            outBits = 64;
        }
        this.mul = new ObservableValue("mul", outBits).setPinDescription(DESCRIPTION);
    }

    @Override
    public void readInputs() throws NodeException {
        this.value = this.signed ? this.a.getValueSigned() * this.b.getValueSigned() : this.a.getValue() * this.b.getValue();
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.mul.setValue(this.value);
    }

    @Override
    public void init(Model model) throws NodeException {
        if (this.bits > 32) {
            throw new BitsException(Lang.get("err_toManyBits_Found_N0_maxIs_N1", this.bits, 32), this);
        }
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.a = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.bits, this, 0);
        this.b = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(this.bits, this, 1);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.mul.asList();
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }
}

