/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.arithmetic;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.arithmetic.Add;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;

public class Sub
extends Add {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Sub.class, PinInfo.input("a"), PinInfo.input("b"), PinInfo.input("c_i")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.BITS).supportsHDL();
    private static final long LOWMASK = Long.MAX_VALUE;
    private static final long CARRYMASK = Long.MIN_VALUE;

    public Sub(ElementAttributes attributes) {
        super(attributes);
        ((ObservableValue)this.getOutputs().get(0)).setPinDescription(DESCRIPTION);
        ((ObservableValue)this.getOutputs().get(1)).setPinDescription(DESCRIPTION);
    }

    @Override
    Add.Calc createCalculation(int bits) {
        if (bits < 64) {
            long mask = Bits.up(1L, bits);
            return (a, b, ci, s, co) -> {
                long value = a - b - ci;
                s.setValue(value);
                co.setBool((value & mask) != 0L);
            };
        }
        return (a, b, ci, s, co) -> {
            long sum = a - b;
            s.setValue(sum - ci);
            co.setBool(Sub.subCarry(a, b) | Sub.subCarry(sum, ci));
        };
    }

    private static boolean subCarry(long x, long y) {
        boolean c = ((x & Long.MAX_VALUE) - (y & Long.MAX_VALUE) & Long.MIN_VALUE) != 0L;
        boolean a = (x & Long.MIN_VALUE) != 0L;
        boolean b = (y & Long.MIN_VALUE) != 0L;
        return !a & b | a == b & c;
    }
}

