/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.element;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ImmutableList<T>
implements List<T> {
    private final T[] items;

    public static <T> ImmutableList<T> combine(ImmutableList<T> a, ImmutableList<T> b) {
        T[] com = Arrays.copyOf(a.items, a.size() + b.size());
        System.arraycopy(b.items, 0, com, a.size(), b.size());
        return new ImmutableList<T>(com);
    }

    public ImmutableList(T ... items) {
        this.items = items;
    }

    public <U extends T> ImmutableList(ImmutableList<U> items) {
        this.items = items.items;
    }

    public <U extends T> ImmutableList(ImmutableList<U> items, int from, int to) {
        this.items = Arrays.copyOfRange(items.items, from, to);
    }

    @Override
    public int size() {
        return this.items.length;
    }

    @Override
    public T get(int i) {
        return this.items[i];
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ImmutableList.this.items.length;
            }

            @Override
            public T next() {
                if (this.pos >= ImmutableList.this.items.length) {
                    throw new IndexOutOfBoundsException();
                }
                return ImmutableList.this.items[this.pos++];
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.items, this.items.length);
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

