/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.element;

import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.lang.Lang;

public class PinInfo
implements PinDescription {
    private final String description;
    private final String name;
    private String langKey;
    private PinDescription.Direction direction;
    private PinDescription.PullResistor pullResistor;
    private String pinNumber;
    private boolean isClock;
    private boolean isSwitchPin;

    public static PinInfo input(String name) {
        return new PinInfo(name, null, PinDescription.Direction.input);
    }

    public static PinInfo input(String name, String description) {
        return new PinInfo(name, description, PinDescription.Direction.input);
    }

    public static PinInfo output(String name) {
        return new PinInfo(name, null, PinDescription.Direction.output);
    }

    public PinInfo(PinDescription description) {
        this(description.getName(), description.getDescription(), description.getDirection(), description.getPullResistor());
        this.pinNumber = description.getPinNumber();
        this.isClock = description.isClock();
        this.isSwitchPin = description.isSwitchPin();
    }

    public PinInfo(String name, String description, PinDescription.Direction direction) {
        this(name, description, direction, PinDescription.PullResistor.none);
    }

    public PinInfo(String name, String description, PinDescription.Direction direction, PinDescription.PullResistor pullResistor) {
        this.description = description;
        this.name = name;
        this.direction = direction;
        this.pullResistor = pullResistor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        String d;
        if (this.description != null) {
            return this.description;
        }
        if (this.langKey != null && (d = Lang.getNull(this.langKey, new Object[0])) != null) {
            return d;
        }
        return this.name;
    }

    @Override
    public PinDescription.Direction getDirection() {
        return this.direction;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public PinDescription.PullResistor getPullResistor() {
        return this.pullResistor;
    }

    @Override
    public String getPinNumber() {
        return this.pinNumber;
    }

    public PinInfo setPinNumber(String pinNumber) {
        this.pinNumber = pinNumber;
        return this;
    }

    public PinInfo setPullResistor(PinDescription.PullResistor pullResistor) {
        this.pullResistor = pullResistor;
        return this;
    }

    void setLangKey(String key) {
        this.langKey = String.valueOf(key) + this.name;
    }

    @Override
    public boolean isClock() {
        return this.isClock;
    }

    public PinInfo setClock() {
        this.isClock = true;
        return this;
    }

    @Override
    public boolean isSwitchPin() {
        return this.isSwitchPin;
    }
}

