/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.Bits;
import de.neemann.digital.hdl.hgs.HGSMap;

public class Port
implements HGSMap {
    private final int bits;
    private final String name;

    public Port(String name, int bits) {
        this.name = name;
        this.bits = bits;
    }

    public Port(String port) {
        int p = port.indexOf(58);
        if (p < 0) {
            this.name = port;
            this.bits = 1;
        } else {
            this.name = port.substring(0, p);
            int b = 1;
            try {
                b = (int)Bits.decode(port.substring(p + 1));
            }
            catch (Bits.NumberFormatException e) {
                b = 1;
            }
            this.bits = b;
        }
    }

    public int getBits() {
        return this.bits;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.bits == 1) {
            return this.name;
        }
        return String.valueOf(this.name) + ":" + this.bits;
    }

    @Override
    public Object hgsMapGet(String key) {
        switch (key) {
            case "name": {
                return this.name;
            }
            case "bits": {
                return this.bits;
            }
        }
        return null;
    }
}

