/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.lang.Lang;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessStarter.class);

    private ProcessStarter() {
    }

    public static String start(File dir, String ... args) throws IOException {
        Process p;
        ProcessBuilder pb = new ProcessBuilder(args).redirectErrorStream(true);
        if (dir != null) {
            pb.directory(dir);
        }
        try {
            p = pb.start();
        }
        catch (IOException e) {
            throw new CouldNotStartProcessException(Lang.get("err_couldNotStartProcess_N", Arrays.toString(args)), e);
        }
        ReaderThread rt = new ReaderThread(p.getInputStream());
        rt.start();
        try {
            int exitValue = p.waitFor();
            rt.join();
            String output = rt.toString();
            if (exitValue != 0) {
                throw new IOException(Lang.get("err_exitValueNotNull_N_O", exitValue, output));
            }
            return output;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static void removeFolder(File dir) {
        File[] list = dir.listFiles();
        if (list != null) {
            File[] fileArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    ProcessStarter.removeFolder(f);
                } else if (!f.delete()) {
                    LOGGER.warn("file " + f + " could not be deleted!");
                }
                ++n2;
            }
        }
        if (!dir.delete()) {
            LOGGER.warn("dir " + dir + " could not be deleted!");
        }
    }

    public static String joinStrings(String ... strings) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            String s = stringArray[n2];
            if (s != null && (str = s.trim()).length() > 0) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(str);
            }
            ++n2;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static final class CouldNotStartProcessException
    extends IOException {
        private CouldNotStartProcessException(String message, IOException cause) {
            super(message, cause);
        }
    }

    private static final class ReaderThread
    extends Thread {
        private final ByteArrayOutputStream baos;
        private final InputStream in;

        private ReaderThread(InputStream in) {
            this.in = in;
            this.baos = new ByteArrayOutputStream();
        }

        @Override
        public void run() {
            try {
                try {
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = this.in.read(buffer)) > 0) {
                        this.baos.write(buffer, 0, len);
                    }
                }
                finally {
                    this.in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public String toString() {
            return this.baos.toString();
        }
    }
}

